/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.javacore.jmiimpl.javamodel;

import java.util.Collections;
import java.util.List;
import javax.jmi.model.MofClass;
import javax.jmi.model.NameNotFoundException;
import javax.jmi.reflect.ConstraintViolationException;
import javax.jmi.reflect.RefObject;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.ElementPartKind;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.jmi.javamodel.TagDefinition;
import org.netbeans.mdr.handlers.InstanceHandler;
import org.netbeans.mdr.storagemodel.StorableObject;

/** TagDefinition object instance interface implementation
 *
 * @author  Vladimir Hudec
 */
public abstract class TagDefinitionImpl extends InstanceHandler implements TagDefinition {
    protected String name = null;
    
    /** Creates a new instance of PackageImpl */
    public TagDefinitionImpl(StorableObject s) {
        super(s);
    }
    
    /**
     * Returns the value of attribute name.
     * @return Value of attribute name.
     */
    public java.lang.String getName() {
        return name;
    }
    
    /**
     * Sets the value of name attribute. See {@link #getName} for description 
     * on the attribute.
     * @param newValue New value to be set.
     */
    public void setName() {
        RefObject nameAttr = null;
        try {
            nameAttr = ((MofClass) refMetaObject()).lookupElementExtended("name"); // NOI18N
        } catch (NameNotFoundException e) {
            // ignore
        }
        throw new ConstraintViolationException(this, nameAttr, "Name is readonly."); // NOI18N
    }

    public int getStartOffset() {
        throw new UnsupportedOperationException();
    }
    
    public int getEndOffset() {
        throw new UnsupportedOperationException();
    }
    
    public int getPartStartOffset(ElementPartKind part) {
        throw new UnsupportedOperationException();
    }

    public int getPartEndOffset(ElementPartKind part) {
        throw new UnsupportedOperationException();
    }
    
    public Element duplicate() {
        throw new UnsupportedOperationException();
    }
    
    public boolean isValid() {
        return true;
    }
    
    public List getChildren() {
        return Collections.EMPTY_LIST;
    }
    
    public void replaceChild(Element oldElement, Element newElement) {
    }
    
    public Resource getResource() {
        return null;
    }
}
