/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.javacore.jmiimpl.javamodel;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

import javax.jmi.reflect.ConstraintViolationException;

import org.netbeans.jmi.javamodel.TagDefinition;
import org.netbeans.jmi.javamodel.TagDefinitionClass;
import org.netbeans.mdr.handlers.ClassProxyHandler;
import org.netbeans.mdr.persistence.MOFID;
import org.netbeans.mdr.persistence.StorageException;
import org.netbeans.mdr.storagemodel.StorableBaseObject;
import org.netbeans.mdr.storagemodel.StorableClass;
import org.netbeans.mdr.util.DebugException;

/** TagDefinition class proxy interface.implementation
 *
 * @author  Vladimir Hudec
 */
public abstract class TagDefinitionClassImpl extends ClassProxyHandler implements TagDefinitionClass {
    private static final String MOFID_PREFIX = "tagdefinition:"; // NOI18N
    private static Map allInstances;
    
    /** Creates a new instance of PackageClassImpl */
    public TagDefinitionClassImpl(StorableClass s) {
        super(s);
    }

    
    public TagDefinition resolve(String name) {
        if (name == null)
            throw new ConstraintViolationException(this, refMetaObject(), "Cannot create instances of TagDefinition with null name supplied."); // NOI18N
            
        initInstances();
        try {
            return _createTagDefinition(name);
        }
        catch (StorageException e) {
            throw new DebugException();
        }
    }

    /**
     * Creates an instance object having attributes initialized by the passed 
     * values.
     * @param name 
     * @return The created instance object.
     */
    public TagDefinition createTagDefinition(String name) {
        return resolve(name);
    }
    
    /**
     * The default factory operation used to create an instance object.
     * @return The created instance object.
     */
    public TagDefinition createTagDefinition() {
        throw new ConstraintViolationException(this, refMetaObject(), "Cannot create instances of TagDefinition without name supplied."); // NOI18N
    }
    
    
    private TagDefinition _createTagDefinition(String name) throws StorageException {
        TagDefinitionImpl tagDefinition = (TagDefinitionImpl) allInstances.get(name);
        if (tagDefinition != null)
            return tagDefinition;
            
        try {
            StorableBaseObject s = _getDelegate();
            DeferredObject o = new DeferredObject(new MOFID(name.hashCode(), MOFID_PREFIX + name), s.getMdrStorage(), s.getImmediatePackageId(), s.getOutermostPackageId(), s.getMetaObject(), (StorableClass) s, null);
            tagDefinition = (TagDefinitionImpl) _getRepository().getHandler(o);
            tagDefinition.name = name;
            allInstances.put(name, tagDefinition);
        }
        catch (StorageException e) {
            throw new DebugException();
        }

        return tagDefinition;
    }
    
    private void initInstances() {
        if (allInstances == null) {
            allInstances=new HashMap();
            try {
                _createTagDefinition("author"); // NOI18N
                _createTagDefinition("version"); // NOI18N
                _createTagDefinition("param"); // NOI18N
                _createTagDefinition("return"); // NOI18N
                _createTagDefinition("exception"); // NOI18N
                _createTagDefinition("see"); // NOI18N
                _createTagDefinition("since"); // NOI18N
                _createTagDefinition("serial"); // NOI18N
                _createTagDefinition("deprecated"); // NOI18N
            }
            catch (StorageException e) {
                throw new DebugException();
            }
        }
    }
    
    protected Collection _allOfClass(boolean recursive) {
        initInstances();
        return Collections.unmodifiableCollection(allInstances.values());
    }
}
