/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.javacore.jmiimpl.javamodel;

import java.lang.reflect.Modifier;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.Resource;
import javax.jmi.reflect.TypeMismatchException;
import java.util.Collection;
import java.util.AbstractCollection;
import java.util.Iterator;
import java.util.ArrayList;
import org.netbeans.modules.javacore.internalapi.ProgressSupport;
import org.openide.util.Utilities;

/**
 *
 * @author Martin Matula
 */
class SubClassesCollection extends AbstractCollection implements TypeVerifier {
    protected final JavaClass superClass;
    protected boolean deterministicProgress;
    

    protected SubClassesCollection(JavaClass superClass, boolean deterministicProgress) {
        this.superClass = (JavaClass) ClassDefinitionImpl.getRealClassDefinition(superClass);
        this.deterministicProgress = deterministicProgress;
    }

    private Resource[] getResources() {
        // extract simple name of the superClass
        int mods=superClass.getModifiers();
        
        if (Modifier.isFinal(mods))
            return new Resource[0];
        return ((FeatureImpl)superClass).findReferencedResources(true); 
    }

    protected java.util.Iterator iterator(Resource[] resources) {
        return new It(resources);
    }

    public Iterator iterator() {
        return iterator(getResources());
    }

    public int size() {
        Resource[] resources = getResources();
        if (resources.length == 0) {
            return 0;
        }
        int size = 0;
        for (Iterator it = iterator(resources); it.hasNext(); size++, it.next());
        return size;
    }

    public boolean isEmpty() {
        Resource[] resources = getResources();
        if (resources.length == 0) {
            return true;
        } else {
            Iterator it = iterator(resources);
            return !it.hasNext();
        }
    }

    public boolean add(Object obj) {
        throw new UnsupportedOperationException();
    }

    public void checkType(Object obj) throws TypeMismatchException {
        throw new UnsupportedOperationException();
    }

    protected boolean acceptClass(ClassDefinition cls) {
        return Utilities.compareObjects(superClass.getName(), getName(ClassDefinitionImpl.getRealClassDefinition(cls.getSuperClass())));
    }
    
    protected static String getName(ClassDefinition cd) {
        return cd == null ? null : cd.getName();
    }

    protected class It implements Iterator {
        private Resource[] resources;
        private int resourceIndex = 0;
        private Iterator classes = null;
        private ClassDefinition next = null;
        private float step;
        private int last;
        private static final int MAX_COUNT=30;
        private ProgressSupport progressSupport;

        protected It(Resource[] resources) {
            this.resources = resources;
            
            step = 1;
            if (resources.length > MAX_COUNT) {
                step = (float) MAX_COUNT / resources.length;
            }
            last = 0;
        
            progressSupport = org.netbeans.modules.javacore.internalapi.JavaMetamodel.getManager().getProgressSupport();
            
        }

        protected void addInnerClasses(Collection col, JavaClass cls) {
            Object[] features=cls.getContents().toArray();
            for (int i=0;i<features.length;i++) {
                Object tmp = features[i];
                if (tmp instanceof JavaClass) {
                    col.add(tmp);
                    addInnerClasses(col, (JavaClass) tmp);
                }
            }
        }

        public boolean hasNext() {
            while (next == null) {
                while (classes == null || !classes.hasNext()) {
                    if (resourceIndex == 0) {
                        if (deterministicProgress)
                            progressSupport.fireProgressListenerStart(0, Math.min(resources.length,MAX_COUNT));
                    }
                    if (resourceIndex < resources.length) {
                        ArrayList al = new ArrayList();
                        for (Iterator it = resources[resourceIndex].getClassifiers().iterator(); it.hasNext();) {
                            Object tmp = it.next();
                            if (tmp instanceof JavaClass) {
                                al.add(tmp);
                                addInnerClasses(al, (JavaClass) tmp);
                            }
                        }
                        classes = al.iterator();
                        resourceIndex++;
                        
                        if (resourceIndex*step >= last + 1 ) {
                            progressSupport.fireProgressListenerStep();
                            last++;
                        }

                    } else {
                        if (deterministicProgress)
                            progressSupport.fireProgressListenerStop();
                        return false;
                    }
                }
                while (classes.hasNext()) {
                    Object subClass = classes.next();
                    if (subClass instanceof ClassDefinition) {
                        if (acceptClass((ClassDefinition) subClass)) {
                            next = (ClassDefinition) subClass;
                            break;
                        }
                    }
                }
            }
            return true;
        }

        public Object next() {
            if (!hasNext()) {
                throw new java.util.NoSuchElementException();
            }
            ClassDefinition last = next;
            next = null;
            return last;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}
