/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.javacore.jmiimpl.javamodel;

import java.util.*;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.StatementBlock;
import org.netbeans.lib.java.parser.ASTree;
import org.netbeans.lib.java.parser.ParserTokens;
import org.netbeans.lib.java.parser.Token;
import org.netbeans.mdr.storagemodel.StorableObject;
import org.netbeans.modules.javacore.parser.ASTProvider;

/**
 *
 * @author  Martin Matula
 */
public abstract class StatementBlockImpl extends StatementImpl implements StatementBlock {
    private LightAttrList statements = null;
    
    /** Creates a new instance of StatementBlockImpl */
    public StatementBlockImpl(StorableObject o) {
        super(o);
    }
    
    /**
     * Returns the value of attribute statements.
     * @return Value of attribute statements.
     */
    public List getStatements() {
        if (!childrenInited) {
            initChildren();
        }
        return statements;
    }
    
    void setStatements(List statements) {
        this.statements = createChildrenList("statements", statements, CHANGED_STATEMENTS); // NOI18N
    }        
    
    protected void _delete() {
        // --- delete components -------------------------------------------
        if (childrenInited) {
            deleteChildren(statements);
        }
        // --- delete links -----------------------------------------------
        // no links to delete
        // --- call super ---------------------------------------
        super._delete();
    }
    
    public void replaceChild(Element oldElement,Element newElement) {
        if (childrenInited) {
            replaceObject(getStatements(),oldElement,newElement);
        }
    }

    public List getChildren() {
        return new ArrayList(getStatements());
    }
    
    protected void initChildren() {
        childrenInited = false;
        statements = createChildrenList(statements, "statements", getASTree().getSubTrees(), CHANGED_STATEMENTS, false); // NOI18N
        childrenInited = true;
    }
    
    String getRawText() {
        StringBuffer buf = new StringBuffer();
        List statements = getStatements();        
        if (isNew()) {
            buf.append('{');
        } else {
            buf.append(IndentUtil.reformatTokenWithPads(this, getASTree().getFirstToken()));
        }
        for (Iterator iter = statements.iterator(); iter.hasNext();) {
            MetadataElement stat = (MetadataElement) iter.next();
            buf.append(stat.getSourceText());
        }
        if (isNew()) {
            formatElementPart(BLOCK_CLOSE_CURLY, buf);
        } else {
            buf.append(IndentUtil.reformatTokenWithPads(this, getASTree().getLastToken()));
        }
        return buf.toString();
    }

    protected String getIndentation() {
        Object comp = refImmediateComposite();
        // for method or for statement block which is not part of another 
        // statement block do not increment the indentation
        if (comp instanceof SemiPersistentElement) {
            return ((SemiPersistentElement) comp).getIndentation();
        } else if (!(comp instanceof StatementBlock)) {
            return ((TransientElement) comp).getIndentation();
        } else {
            return ((TransientElement) comp).getIndentation().concat(INDENTATION);
        }
    }

    public void getDiff(List diff) {
        ASTProvider parser = getParser();
        ASTree tree = getASTree();
        ASTree[] children = tree.getSubTrees();
        if (children == null)
            children = new ASTree[0];
        
        Token startToken = parser.getToken(tree.getLastToken());
        if (isChanged(CHANGED_STATEMENTS)) {
            getStatementsDiff(diff, parser, children, getStatements(), getTokenStart(parser, startToken), "", null, 0, true);
        } else if (isChanged(CHANGED_CHILDREN)) {
            getElementsDiff(diff, getStatements());
        }
    }
    
    private static int getTokenStart(ASTProvider parser, Token startToken) {
        int startOffset = parser.getToken(startToken.getFirstToken()-1).getEndOffset();
        Token[] pad = startToken.getPadding();
        if (pad.length > 0) {
            for (int i = 0; i < pad.length; i++) {
                if (pad[i].getType() == ParserTokens.EOL) {
                    break;
                }
            }
        }
        return startOffset;
        /*
        Token[] pad = startToken.getPadding();
        if (pad.length > 0) {
            startToken = pad[0];
            for (int i = 0; i < pad.length; i++) {
                if (pad[i].getType() == ParserTokens.EOL) {
                    return pad[i].getStartOffset();
                }
            }
        }
        return startToken.getStartOffset();
         */
    }
    
    protected int getStartOffset(ASTProvider parser, ASTree tree, boolean includePaddings) {
        Token startToken = parser.getToken(tree.getFirstToken());
        if (includePaddings) {
            return getTokenStart(parser, startToken);
        }
        return startToken.getStartOffset();
    }
    
    public Element duplicate(JavaModelPackage targetExtent) {
        return targetExtent.getStatementBlock().createStatementBlock(duplicateList(getStatements(), targetExtent));
    }
}
