/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.javacore.jmiimpl.javamodel;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.jmi.model.MofClass;
import javax.jmi.model.NameNotFoundException;
import javax.jmi.reflect.ConstraintViolationException;
import javax.jmi.reflect.RefObject;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.ElementPartKind;
import org.netbeans.jmi.javamodel.PrimitiveType;
import org.netbeans.jmi.javamodel.PrimitiveTypeKind;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.mdr.handlers.InstanceHandler;
import org.netbeans.mdr.storagemodel.StorableObject;

/**
 *
 * @author Martin Matula
 */
public abstract class PrimitiveTypeImpl extends InstanceHandler implements PrimitiveType {
    PrimitiveTypeKind kind = null;
    
    /** Creates a new instance of PackageImpl */
    public PrimitiveTypeImpl(StorableObject s) {
        super(s);
    }
    
    public PrimitiveTypeKind getKind() {
        return kind;
    }
    
    public String getName() {
        return kind.toString();
    }
    
    public void setName() {
        RefObject nameAttr = null;
        try {
            nameAttr = ((MofClass) refMetaObject()).lookupElementExtended("name"); // NOI18N
        } catch (NameNotFoundException e) {
            // ignore
        }
        throw new ConstraintViolationException(this, nameAttr, "Name is readonly."); // NOI18N
    }

    public void replaceChild(Element oldChild, Element newChild) {
        throw new UnsupportedOperationException();
    }

    public int getPartStartOffset(ElementPartKind part) {
        throw new UnsupportedOperationException();
    }

    public int getPartEndOffset(ElementPartKind part) {
        throw new UnsupportedOperationException();
    }

    public Resource getResource() {
        return null;
    }

    public void setName(String newValue) {
        throw new UnsupportedOperationException();
    }

    public boolean isValid() {
        return true;
    }

    public Collection getReferences() {
        return Collections.EMPTY_LIST;
    }

    public Element duplicate() {
        throw new UnsupportedOperationException();
    }

    public int getStartOffset() {
        throw new UnsupportedOperationException();
    }

    public List getChildren() {
        return Collections.EMPTY_LIST;
    }

    public int getEndOffset() {
        throw new UnsupportedOperationException();
    }
}
