/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.javacore.jmiimpl.javamodel;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.jmi.reflect.ConstraintViolationException;
import org.netbeans.jmi.javamodel.*;
import org.netbeans.mdr.handlers.ClassProxyHandler;
import org.netbeans.mdr.persistence.MOFID;
import org.netbeans.mdr.persistence.StorageException;
import org.netbeans.mdr.storagemodel.StorableBaseObject;
import org.netbeans.mdr.storagemodel.StorableClass;
import org.netbeans.mdr.util.DebugException;
import org.netbeans.modules.javacore.api.JavaModel;

/**
 *
 * @author Martin Matula
 */
public abstract class PrimitiveTypeClassImpl extends ClassProxyHandler implements PrimitiveTypeClass {
    private static final String MOFID_PREFIX = "primitive:"; // NOI18N
    private static Map allInstances;
    
    /** Creates a new instance of PackageClassImpl */
    public PrimitiveTypeClassImpl(StorableClass s) {
        super(s);
    }
    
    public PrimitiveType createPrimitiveType(String name, PrimitiveTypeKind kind) {
        throw new ConstraintViolationException(this, refMetaObject(), "Cannot explicitly create instances of PrimitiveType."); // NOI18N
    }
    
    public PrimitiveType createPrimitiveType() {
        throw new ConstraintViolationException(this, refMetaObject(), "Cannot explicitly create instances of PrimitiveType."); // NOI18N
    }
    
    private void initInstances() {
        if (allInstances == null) {
            if (JavaModel.getDefaultExtent().equals(refImmediatePackage())) {
                try {
                    StorableBaseObject s = _getDelegate();
                    DeferredObject o;
                    PrimitiveTypeImpl pt;
                    PrimitiveTypeKind pk;

                    allInstances=new HashMap();
                    // void
                    pk = PrimitiveTypeKindEnum.VOID;
                    o = new DeferredObject(new MOFID(1, MOFID_PREFIX + pk.toString()), s.getMdrStorage(), s.getImmediatePackageId(), s.getOutermostPackageId(), s.getMetaObject(), (StorableClass) s, null);
                    pt = (PrimitiveTypeImpl) _getRepository().getHandler(o);
                    pt.kind = pk;
                    allInstances.put(pk.toString(), pt);

                    // boolean
                    pk = PrimitiveTypeKindEnum.BOOLEAN;
                    o = new DeferredObject(new MOFID(2, MOFID_PREFIX + pk.toString()), s.getMdrStorage(), s.getImmediatePackageId(), s.getOutermostPackageId(), s.getMetaObject(), (StorableClass) s, null);
                    pt = (PrimitiveTypeImpl) _getRepository().getHandler(o);
                    pt.kind = pk;
                    allInstances.put(pk.toString(), pt);

                    // byte
                    pk = PrimitiveTypeKindEnum.BYTE;
                    o = new DeferredObject(new MOFID(3, MOFID_PREFIX + pk.toString()), s.getMdrStorage(), s.getImmediatePackageId(), s.getOutermostPackageId(), s.getMetaObject(), (StorableClass) s, null);
                    pt = (PrimitiveTypeImpl) _getRepository().getHandler(o);
                    pt.kind = pk;
                    allInstances.put(pk.toString(), pt);

                    // char
                    pk = PrimitiveTypeKindEnum.CHAR;
                    o = new DeferredObject(new MOFID(4, MOFID_PREFIX + pk.toString()), s.getMdrStorage(), s.getImmediatePackageId(), s.getOutermostPackageId(), s.getMetaObject(), (StorableClass) s, null);
                    pt = (PrimitiveTypeImpl) _getRepository().getHandler(o);
                    pt.kind = pk;
                    allInstances.put(pk.toString(), pt);

                    // double
                    pk = PrimitiveTypeKindEnum.DOUBLE;
                    o = new DeferredObject(new MOFID(5, MOFID_PREFIX + pk.toString()), s.getMdrStorage(), s.getImmediatePackageId(), s.getOutermostPackageId(), s.getMetaObject(), (StorableClass) s, null);
                    pt = (PrimitiveTypeImpl) _getRepository().getHandler(o);
                    pt.kind = pk;
                    allInstances.put(pk.toString(), pt);

                    // float
                    pk = PrimitiveTypeKindEnum.FLOAT;
                    o = new DeferredObject(new MOFID(6, MOFID_PREFIX + pk.toString()), s.getMdrStorage(), s.getImmediatePackageId(), s.getOutermostPackageId(), s.getMetaObject(), (StorableClass) s, null);
                    pt = (PrimitiveTypeImpl) _getRepository().getHandler(o);
                    pt.kind = pk;
                    allInstances.put(pk.toString(), pt);

                    // int
                    pk = PrimitiveTypeKindEnum.INT;
                    o = new DeferredObject(new MOFID(7, MOFID_PREFIX + pk.toString()), s.getMdrStorage(), s.getImmediatePackageId(), s.getOutermostPackageId(), s.getMetaObject(), (StorableClass) s, null);
                    pt = (PrimitiveTypeImpl) _getRepository().getHandler(o);
                    pt.kind = pk;
                    allInstances.put(pk.toString(), pt);

                    // long
                    pk = PrimitiveTypeKindEnum.LONG;
                    o = new DeferredObject(new MOFID(8, MOFID_PREFIX + pk.toString()), s.getMdrStorage(), s.getImmediatePackageId(), s.getOutermostPackageId(), s.getMetaObject(), (StorableClass) s, null);
                    pt = (PrimitiveTypeImpl) _getRepository().getHandler(o);
                    pt.kind = pk;
                    allInstances.put(pk.toString(), pt);

                    // short
                    pk = PrimitiveTypeKindEnum.SHORT;
                    o = new DeferredObject(new MOFID(9, MOFID_PREFIX + pk.toString()), s.getMdrStorage(), s.getImmediatePackageId(), s.getOutermostPackageId(), s.getMetaObject(), (StorableClass) s, null);
                    pt = (PrimitiveTypeImpl) _getRepository().getHandler(o);
                    pt.kind = pk;
                    allInstances.put(pk.toString(), pt);
                } catch (StorageException e) {
                    throw new DebugException();
                }
            } else {
                ((PrimitiveTypeClassImpl) JavaModel.getDefaultExtent().getPrimitiveType()).initInstances();
        }
    }
    }
    
    PrimitiveType resolveType(String name) {
        initInstances();
        return (PrimitiveType) allInstances.get(name);
    }

    protected Collection _allOfClass(boolean recursive) {
        initInstances();
        return Collections.unmodifiableCollection(allInstances.values());
    }
    
    public org.netbeans.jmi.javamodel.Type resolve(java.lang.String name) {
        JavaModelPackage pkg = (JavaModelPackage) refImmediatePackage();
        return pkg.getType().resolve(name);
    }
}
