/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.javacore.jmiimpl.javamodel;

import java.util.*;
import org.netbeans.jmi.javamodel.*;
import org.netbeans.lib.java.parser.ASTree;
import org.netbeans.mdr.storagemodel.StorableObject;
import org.netbeans.modules.javacore.parser.ASTProvider;

/**
 *
 * @author  Martin Matula
 */
public abstract class PrefixExpressionImpl extends ExpressionImpl implements PrefixExpression {
    protected Operator operator = null;
    protected UnaryExpression expression = null;
    
    /** Creates a new instance of PrefixExpressionImpl */
    public PrefixExpressionImpl(StorableObject o) {
        super(o);
    }
    
    public void setExpression(UnaryExpression expression) {
        objectChanged(CHANGED_EXPRESSION);
        changeChild(getExpression(), expression);
        this.expression = expression;
    }
    
    public UnaryExpression getExpression() {
        if (!childrenInited) {
            initChildren();
        }
        return expression;
    }
    
    public void setOperator(Operator operator) {
        objectChanged(CHANGED_OPERATOR);
        this.operator = operator;
    }
    
    public Operator getOperator() {
        if (isChanged(CHANGED_OPERATOR)) {
            return operator;
        } else {
            return extractOperator();
        }
    }

    protected Operator extractOperator() {
        return getOperator(getASTree().getSubTrees()[0].getType());
    }

    public List getChildren() {
        List list = new ArrayList(1);
        addIfNotNull(list, getExpression()); 
        return list;
    }
    
    protected void initChildren() {
        childrenInited = false;
        ASTree tree = getASTree();
        if (tree != null) {
            expression = (UnaryExpression) initOrCreate(expression, tree.getSubTrees()[1]);
        }
        childrenInited = true;
    }
    
    public String getSourceText() {
        String origElem;
        if ((origElem = checkChange()) != null)
            return origElem;
        StringBuffer buf = new StringBuffer();
        StatementImpl expr = (StatementImpl) getExpression();
        Operator operator = getOperator();        
        buf.append(operatorToString(operator));
        buf.append(expr.getSourceText());
        return buf.toString();
    }
        
    public void getDiff(List diff) {
        ASTProvider parser = getParser();
        ASTree tree = getASTree();
        ASTree[] children = tree.getSubTrees();
        
        if (isChanged(CHANGED_OPERATOR)) {            
            replaceNode(diff, parser, children[0], operatorToString(operator), 0, null);
        }
        getChildDiff(diff, parser, children[1], (MetadataElement) getExpression(), CHANGED_EXPRESSION);
    }
    
    protected String operatorToString (Operator op) {
        if (op == OperatorEnum.INC) return "++"; // NOI18N
        if (op == OperatorEnum.DEC) return "--"; // NOI18N
        if (op == OperatorEnum.NOT) return "!"; // NOI18N
        if (op == OperatorEnum.COMP) return "~"; // NOI18N
        if (op == null) return "";
        return "???"; // [PENDING] // NOI18N
    }
    
    void setData(Operator operator, UnaryExpression expression) {
        this.operator = operator;
        changeChild(null, expression);
        this.expression = expression;
    }

    protected void _delete() {
        // --- delete components -------------------------------------------
        if (childrenInited) {
            deleteChild(expression);
        }
        // --- delete links -----------------------------------------------
        // no links to delete
        // --- call super ---------------------------------------
        super._delete();
    }
    
    public void replaceChild(Element oldElement,Element newElement) {
        if (childrenInited) {
            if (oldElement.equals(expression)) {
                setExpression((UnaryExpression)newElement);
            }
        }
    }
    
    public Element duplicate(JavaModelPackage targetExtent) {
        return targetExtent.getPrefixExpression().createPrefixExpression(
                getOperator(), (UnaryExpression) duplicateElement(getExpression(), targetExtent));
    }
}
