/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.javacore.jmiimpl.javamodel;

import java.util.List;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.Operator;
import org.netbeans.jmi.javamodel.PostfixExpression;
import org.netbeans.jmi.javamodel.UnaryExpression;
import org.netbeans.lib.java.parser.ASTree;
import org.netbeans.mdr.storagemodel.StorableObject;
import org.netbeans.modules.javacore.parser.ASTProvider;

/**
 *
 * @author  mm109185
 */
public abstract class PostfixExpressionImpl extends PrefixExpressionImpl implements PostfixExpression {
    /** Creates a new instance of PostfixExpressionImpl */
    public PostfixExpressionImpl(StorableObject o) {
        super(o);
    }

    protected Operator extractOperator() {
        if (getASTree().getSubTrees().length > 1) {
            return getOperator(getASTree().getSubTrees()[1].getType());
        } else {
            return null;
        }
    }

    protected void initChildren() {
        childrenInited = false;
        ASTree tree = getASTree();
        if (tree != null) {
            expression = (UnaryExpression) initOrCreate(expression, tree.getSubTrees()[0]);
        }
        childrenInited = true;
    }
    
    public String getSourceText() {
        String origElem;
        if ((origElem = checkChange()) != null)
            return origElem;
        StringBuffer buf = new StringBuffer();
        StatementImpl expr = (StatementImpl) getExpression();
        Operator operator = getOperator();        
        buf.append(expr.getSourceText());
        buf.append(operatorToString(operator));
        return buf.toString();
    }

    public void getDiff(List diff) {
        ASTProvider parser = getParser();
        ASTree tree = getASTree();
        ASTree[] children = tree.getSubTrees();
                
        getChildDiff(diff, parser, children[0], (MetadataElement) getExpression(), CHANGED_EXPRESSION);
        if (isChanged(CHANGED_OPERATOR)) {
            int pos = parser.getToken(children[0].getLastToken()).getEndOffset();
            replaceNode(diff, parser, children[1], operatorToString(operator), pos, "");
        }
    }
    
    public Element duplicate(JavaModelPackage targetExtent) {
        return targetExtent.getPostfixExpression().createPostfixExpression(
                getOperator(),
                (UnaryExpression) duplicateElement(getExpression(), targetExtent)
               );
                
    }
}
