/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *  
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *  
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.javacore.jmiimpl.javamodel;

import org.netbeans.jmi.javamodel.Parameter;
import org.netbeans.jmi.javamodel.ParameterClass;
import org.netbeans.jmi.javamodel.TypeReference;
import org.netbeans.mdr.storagemodel.StorableClass;
import org.netbeans.modules.javacore.parser.TypeRef;

public abstract class ParameterClassImpl extends SemiPersistentClass implements ParameterClass {
    
    protected ParameterClassImpl(StorableClass s) {
        super(s);
    }
    
    public Parameter createParameter() {
        return create(null, null, false, null, 0, false);
    }

    public Parameter createParameter(java.lang.String name, java.util.List annotations, boolean isFinal, TypeReference typeName, int dimCount, boolean isVarArg) {
        return create(name, annotations, isFinal, typeName, dimCount, isVarArg);
    }
    
    private Parameter create(java.lang.String name, java.util.List annotations, boolean isFinal, TypeReference typeName, int dimCount, boolean isVarArg) {
        ParameterImpl result = create(name, isFinal, isVarArg, null, false);
        result.setNew();
        result.setData(annotations, typeName, dimCount);
        return result;
    }

    protected abstract Parameter super_createParameter(java.lang.String name, java.util.List annotations, boolean isFinal, TypeReference typeName, int dimCount, boolean isVarArg);

    public ParameterImpl create(String name, boolean isFinal, boolean isVarArg, TypeRef type, boolean isTransient) {
        ParameterImpl result;
        if (isTransient) {
            result = (ParameterImpl) createTransient();
            boolean changes = result.disableChanges;
            result.disableChanges = true;
            try {
                result.setName(name);
                result.setFinal(isFinal);
                result.setVarArg(isVarArg);
            } finally {
                result.disableChanges = changes;
            }
        } else {
            result = (ParameterImpl) super_createParameter(name, null, isFinal, null, 0, isVarArg);
        }
        result.setTypeRef(type);
        return result;
    }
}
