/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.javacore.jmiimpl.javamodel;

import java.util.List;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.NullLiteral;
import org.netbeans.mdr.storagemodel.StorableObject;

/**
 *
 * @author  Martin Matula
 */
public abstract class NullLiteralImpl extends LiteralImpl implements NullLiteral {
    
    /** Creates a new instance of NullLiteralImpl */
    public NullLiteralImpl(StorableObject o) {
        super(o);
    }
    
    public String getSourceText() {
        String origElem;
        if ((origElem = checkChange()) != null)
            return origElem;
        return "null"; // NOI18N
    }
    
    public void getDiff(List diff) {
        // never called
    }

    public Element duplicate(JavaModelPackage targetExtent) {
        return targetExtent.getNullLiteral().createNullLiteral();
    }
}
