/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.javacore.jmiimpl.javamodel;

import java.util.List;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.ArrayList;
import java.util.AbstractList;
import java.util.Collection;
import org.netbeans.jmi.javamodel.JavaClass;


public class NotifierList implements List {
    
    private List innerList;
    private ChangeNotificationListener notificationListener;
    
    public NotifierList(List innerList, ChangeNotificationListener notificationListener) {
        setInnerList(innerList);
        setNotificationListener(notificationListener);
    }

    public NotifierList(List innerList) {
        setInnerList(innerList);
        setNotificationListener(null);
    }

    public void setInnerList(List innerList) {
        this.innerList = innerList;        
    }
    
    public void setNotificationListener(ChangeNotificationListener notificationListener) {
        this.notificationListener = notificationListener;
    }
    
    private void notifyChange(boolean add, Object o) {
        if (notificationListener != null)
            notificationListener.notifyChange(add, o);
    }
    
    private void notifyChange(boolean add, Collection c) {
        if (notificationListener != null)
            notificationListener.notifyChange(add, c);
    }

    // ..........................................................................
    
    public boolean remove(Object obj) {
        boolean result = innerList.remove(obj);
        if (result)
            notifyChange(false, obj);
        return result;
    }
    
    public Object set(int param, Object obj) {
        Object result = innerList.set(param, obj);
        notifyChange(true, obj);
        if (result != null)
            notifyChange(false, result);
        return result;
    }
    
    public Object remove(int param) {        
        Object result = innerList.remove(param);
        if (result != null)
            notifyChange(false, result);
        return result;
    }
    
    public void add(int param, Object obj) {        
        innerList.add(param, obj);
        notifyChange(true, obj);
    }
    
    public boolean add(Object obj) {        
        boolean result = innerList.add(obj);
        notifyChange(true, obj);
        return result;
    }
    
    public ListIterator listIterator(int param) {
        return new NotifierListIterator(innerList.listIterator(param));
    }
    
    public Iterator iterator() {
        return new NotifierListIterator(innerList.listIterator());
    }
    
    public ListIterator listIterator() {
        return new NotifierListIterator(innerList.listIterator());
    }
    
    public List subList(int param, int param1) {
        return new NotifierList(innerList.subList(param,  param1), notificationListener);
    }
    
    public boolean contains(Object obj) {
        return innerList.contains(obj);
    }
    
    public boolean containsAll(Collection collection) {
        return innerList.containsAll(collection);
    }
    
    public boolean addAll(Collection c) {
        boolean result = innerList.addAll(c);
        if (result) {
            notifyChange(true, c);
        }
        return result;
    }
    
    public void clear() {
        // should be called before asked operation to enable proper cleaning
        notifyChange(false, null);
        innerList.clear();
    }
    
    public boolean isEmpty() {
        return innerList.isEmpty();
    }
    
    public boolean removeAll(Collection c) {
        // should be called before asked operation to enable proper cleaning
        notifyChange(false, null);
        return innerList.removeAll(c);
    }
    
    public boolean retainAll(Collection c) {
        // should be called before asked operation to enable proper cleaning
        notifyChange(false, null);
        return innerList.retainAll(c);
    }
    
    public int size() {
        return innerList.size();
    }
    
    public Object[] toArray() {
        return innerList.toArray();
    }
    
    public Object[] toArray(Object[] a) {
        return innerList.toArray(a);
    }
    
    public boolean addAll(int index, Collection c) {
        boolean result = innerList.addAll(index, c);
        if (result) {
            notifyChange(true, c);
        }
        return result;
    }
    
    public Object get(int index) {
        return innerList.get(index);
    }
    
    public int indexOf(Object o) {
        return innerList.indexOf(o);
    }
    
    public int lastIndexOf(Object o) {
        return innerList.lastIndexOf(o);
    }

    // ListIterator .................................................
    class NotifierListIterator implements ListIterator {
        
        private Object lastRead;
        private ListIterator innerIterator;
        
        NotifierListIterator(ListIterator iterator) {
            this.innerIterator = iterator;
        }
        
        public void remove() {
            innerIterator.remove();
            if (lastRead != null)
                notifyChange(false, lastRead);
        }
        
        public void add(Object obj) {            
            innerIterator.add(obj);
            notifyChange(true, obj);
        }
        
        public void set(Object obj) {
            innerIterator.set(obj);
            notifyChange(true, obj);
            if (lastRead != null)
                notifyChange(false, lastRead);
        }
        
        public boolean hasNext() {
            return innerIterator.hasNext();
        }
        
        public boolean hasPrevious() {
            return innerIterator.hasPrevious();
        }
        
        public Object next() {
            return lastRead = innerIterator.next();
        }

        public int nextIndex() {
            return innerIterator.nextIndex();
        }
        
        public Object previous() {
            return lastRead = innerIterator.previous();
        }
        
        public int previousIndex() {
            return innerIterator.previousIndex();
        }
    }
}
