/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.javacore.jmiimpl.javamodel;

import org.netbeans.jmi.javamodel.*;
import org.netbeans.lib.java.parser.ASTree;
import org.netbeans.lib.java.parser.ASTreeTypes;
import org.netbeans.mdr.storagemodel.StorableObject;
import org.netbeans.modules.javacore.parser.ASTProvider;
import java.util.*;

/**
 *
 * @author  Martin Matula
 */
public abstract class NewArrayExpressionImpl extends ExpressionImpl implements NewArrayExpression {
    private ArrayInitialization initializer;
    private LightAttrList dimensions;
    private MultipartId typeName;
    private int dimCount;

    /** Creates a new instance of NewArrayExpressionImpl */
    public NewArrayExpressionImpl(StorableObject o) {
        super(o);
    }

    public MultipartId getTypeName() {
        if (!childrenInited) {
            initChildren();
        }
        return typeName;
    }

    public void setTypeName(MultipartId typeName) {
        objectChanged(CHANGED_TYPE);
        changeChild(getTypeName(), typeName);
        this.typeName = typeName;
    }

    public Type getType() {
        Type t = (Type) getTypeName().getElement();
        int dims = getDimCount();
        ArrayClass arrayClass = ((JavaModelPackage)t.refImmediatePackage()).getArray();
        for (int i = 0; i < dims; i++) {
            t = arrayClass.resolveArray(t);
        }
        return t;
    }
    
    public void setType(Type newValue) {
        MultipartIdClass proxy = ((JavaModelPackage) refImmediatePackage()).getMultipartId();
        setTypeName(proxy.createMultipartId(newValue.getName(), null, null));
    }
    
    public int getDimCount() {
        if (isChanged(CHANGED_DIM_COUNT)) {
            return dimCount;
        } else {
            ASTree dims = getASTree().getSubTrees()[2];
            int dimSize = dims == null ? 0 : (dims.getLastToken() - dims.getFirstToken() + 1) / 2;
            return getDimensions().size() + dimSize;
        }
    }

    public void setDimCount(int dimCount) {
        objectChanged(CHANGED_DIM_COUNT);
        this.dimCount = dimCount;
    }

    public ArrayInitialization getInitializer() {
        if (!childrenInited) {
            initChildren();
        }
        return initializer;
    }
    
    public void setInitializer(ArrayInitialization initializer) {
        objectChanged(CHANGED_INITIALIZER);
        changeChild(getInitializer(), initializer);
        this.initializer = initializer;
    }
    
    public List getDimensions() {
        if (!childrenInited) {
            initChildren();
        }
        return dimensions;
    }
    
    public List getChildren() {
        List list = new ArrayList(2 + getDimensions().size());
        addIfNotNull(list, getTypeName());
        list.addAll(getDimensions()); 
        addIfNotNull(list, getInitializer());
        return list;
    }
    
    protected void initChildren() {
        childrenInited = false;
        ASTree tree = getASTree();
        if (tree != null) {
            ASTree[] parts = tree.getSubTrees();
            typeName = (MultipartId) initOrCreate(typeName, parts[0]);
            dimensions = createChildrenList(dimensions, "dimensions", parts[1], ASTreeTypes.DIM_EXPRS, CHANGED_DIMENSIONS, false); // NOI18N
            initializer = (ArrayInitialization) initOrCreate(initializer, parts[3]);
        }
        childrenInited = true;
    }
    
    public String getSourceText() {
        String origElem;
        if ((origElem = checkChange()) != null)
            return origElem;
        StringBuffer buf = new StringBuffer();
        TransientElement initializer = (TransientElement) getInitializer();
        buf.append("new "); // NOI18N
        buf.append(((MetadataElement) getTypeName()).getSourceText());
        appendDimensions(buf);
        if (initializer != null) {
            buf.append(initializer.getSourceText());
        }            
        return buf.toString();
    }

    private StringBuffer appendDimensions(StringBuffer buf) {
        List exprs = getDimensions();
        int totalDim = getDimCount();
        for (Iterator iter = exprs.iterator(); iter.hasNext();) {
            TransientElement expr = (TransientElement) iter.next();
            formatElementPart(ARRAY_OPEN_BRACKET, buf);
            buf.append(expr.getSourceText());
            formatElementPart(ARRAY_CLOSE_BRACKET, buf);
            totalDim--;
        }
        for (; totalDim > 0; totalDim--) {
            formatElementPart(ARRAY_OPEN_BRACKET, buf);
            formatElementPart(ARRAY_CLOSE_BRACKET, buf);
        }
        return buf;
    }

    public void getDiff(List diff) {
        ASTProvider parser = getParser();
        ASTree tree = getASTree();
        ASTree[] children = tree.getSubTrees();

        getChildDiff(diff, parser, children[0], (MetadataElement) getTypeName(), CHANGED_TYPE);
        if (isChanged(CHANGED_DIMENSIONS | CHANGED_DIM_COUNT)) {
            ASTree startTree = children[1] == null ? children[2] : children[1];
            ASTree endTree = children[2] == null ? children[1] : children[2];
            diff.add(new DiffElement(getStartOffset(parser, startTree, false), getEndOffset(parser, endTree), appendDimensions(new StringBuffer()).toString()));
        } else {
            getCollectionDiff(diff, parser, CHANGED_DIMENSIONS, children[1], ASTreeTypes.DIM_EXPRS, getDimensions(), 0, null);
        }
        int index = (children[2] == null ? (children[1] == null ? children[0] : children[1]) : children[2]).getLastToken();
        int startOffset = parser.getToken(index).getEndOffset();
        getChildDiff(diff, parser, children[3], (MetadataElement) getInitializer(), CHANGED_INITIAL_VALUE, startOffset, " "); // NOI18N
    }
    
    void setData(List dimensions, ArrayInitialization initializer, MultipartId typeName, int dimCount) {
        // dimensions
        this.dimensions = createChildrenList("dimensions", dimensions, CHANGED_DIMENSIONS); // NOI18N
        // initializer
        changeChild(null, initializer);
        this.initializer = initializer;
        // typeName
        changeChild(null, typeName);
        this.typeName = typeName;
        // dimCount
        this.dimCount = dimCount;
    }

    protected void _delete() {
        // --- delete components -------------------------------------------
        if (childrenInited) {
            deleteChildren(dimensions);
            deleteChild(initializer);
            deleteChild(typeName);
        }
        // --- delete links -----------------------------------------------
        // no links to delete
        // --- call super ---------------------------------------
        super._delete();
    }
    
    public void replaceChild(Element oldElement,Element newElement) {
        if (childrenInited) {
            if (replaceObject(getDimensions(),oldElement,newElement))
                return;
            if (oldElement.equals(initializer)) {
                setInitializer((ArrayInitialization)newElement);
            } else if (oldElement.equals(typeName)) {
                setTypeName((MultipartId)newElement);
            }
        }
    }
    
    public Element duplicate(JavaModelPackage targetExtent) {
        return targetExtent.getNewArrayExpression().createNewArrayExpression(
                (MultipartId) duplicateElement(getTypeName(), targetExtent),
                duplicateList(getDimensions(), targetExtent),
                getDimCount(),
                (ArrayInitialization) duplicateElement(getInitializer(), targetExtent)
               );
    }
}
