/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.javacore.jmiimpl.javamodel;

import java.util.*;
import org.netbeans.jmi.javamodel.*;
import org.netbeans.lib.java.parser.ASTree;
import org.netbeans.lib.java.parser.ASTreeTypes;
import org.netbeans.lib.java.parser.ParserTokens;
import org.netbeans.mdr.storagemodel.StorableObject;
import org.netbeans.modules.javacore.internalapi.JavaModelUtil;
import org.netbeans.modules.javacore.parser.MDRParser;

/**
 *
 * @author Martin Matula
 */
public abstract class MultipartIdImpl extends TypeReferenceImpl implements MultipartId {
    private LightAttrList typeArguments;

    /** Creates a new instance of MultipartIdImpl */
    public MultipartIdImpl(StorableObject o) {
        super(o);
    }

    void setData(String name, MultipartId parent, List typeArguments) {
        super.setData(name, parent);
        this.typeArguments = createChildrenList("typeArguments", typeArguments, CHANGED_TYPE_ARGUMENTS); // NOI18N
    }

    protected void initChildren() {
        childrenInited = false;
        ASTree tree = getASTree();
        ASTree[] children = tree.getSubTrees();
        typeArguments = createChildrenList(typeArguments, "typeArguments", children == null || children.length < 3 ? null : children[2], ASTreeTypes.TYPE_ARGUMENTS, CHANGED_TYPE_ARGUMENTS, false); // NOI18N
        super.initChildren();
    }

    protected ASTree getNameAST() {
        ASTree tree = getASTree();
        if (tree.getType() == ASTreeTypes.MULTI_PART_ID) {
            tree = tree.getSubTrees()[1];
        }
        return tree;
    }

    public List getTypeArguments() {
        if (!childrenInited) {
            initChildren();
        }
        return typeArguments;
    }

    public String getSourceText() {
        return getRawText();
    }
    
    String getRawText() {
        StringBuffer buf = new StringBuffer();
        MetadataElement parent = (MetadataElement) getParent();
        if (parent != null) {
            buf.append(parent.getSourceText() + '.');
        }
        buf.append(getName());
        generateNewTypeArguments(buf);
        return buf.toString();
    }

    private void generateNewTypeArguments(StringBuffer buf) {
        if (!typeArguments.isEmpty()) {
            buf.append('<');
            Iterator it = typeArguments.iterator();
            while (it.hasNext()) {
                buf.append(((MetadataElement) it.next()).getSourceText());
                if (it.hasNext()) {
                    formatElementPart(MetadataElement.COMMA, buf);
                }
            }
            buf.append('>');
        }
    }

    public void getDiff(List diff) {
        MDRParser parser = getParser();
        ASTree tree = getASTree();
        ASTree[] children = tree.getSubTrees();
        ASTree nameAST = getNameAST();
        ASTree parentAST = null;
        
        if (tree.getType() == ASTreeTypes.MULTI_PART_ID && children != null && children.length > 0) {
            parentAST = children[0];
        }
        
        if (isChanged(CHANGED_PARENT) && parentAST != null && getParent()==null) {
            // parent was there, but is not here any more
            int start = getStartOffset(parser, children[0], false);
            int end = getEndOffset(parser,children[0]);
            diff.add(new DiffElement(start, end + 1, ""));
        } else {
            getChildDiff(diff, parser, parentAST, (MetadataElement) getParent(), CHANGED_PARENT, getStartOffset(parser, tree, false), "");
        }

        if (isChanged(CHANGED_NAME)) {
            replaceNode(diff, parser, nameAST, getName(), 0, null);
        }

        if (children == null || children.length < 3 || children[2] == null) {
            if (isChanged(CHANGED_TYPE_ARGUMENTS)) {
                StringBuffer buf = new StringBuffer();
                generateNewTypeArguments(buf);
                int endOffset = getEndOffset(parser, getNameAST());
                diff.add(new DiffElement(endOffset, endOffset, buf.toString()));
            }
        } else if (getTypeArguments().isEmpty()) {
            if (isChanged(CHANGED_TYPE_ARGUMENTS)) {
                replaceNode(diff, parser, children[2], "", 0, null);
            }
        } else {
            getCollectionDiff(diff, parser, CHANGED_TYPE_ARGUMENTS, children[2], ASTreeTypes.TYPE_ARGUMENTS, getTypeArguments(), parser.getToken(children[2].getLastToken()).getStartOffset(), ", "); // NOI18N
        }
    }

    public NamedElement getElement() {
        ASTree tree = getASTree();
        if (tree == null) {
            // [PENDING] remove this branch when semantic info for new elements is fixed
            TypeClass typeClass = ((JavaModelPackage) refImmediatePackage()).getType();
            NamedElement result = typeClass.resolve(getName());
            if (result instanceof UnresolvedClass) {
                JavaPackage pkg = ((JavaModelPackage) refImmediatePackage()).getJavaPackage().resolvePackage(getName());
                if (pkg != null) {
                    return pkg;
                }
            }
            return result;
        } else {
            MDRParser parser = (MDRParser) tree.getASTContext();
            switch (tree.getType()) {
                case ASTreeTypes.MULTI_PART_ID:
                    return (NamedElement) parser.getSemanticInfo(tree.getSubTrees()[1], this);
                case ParserTokens.IDENTIFIER:
                    return (NamedElement) parser.getSemanticInfo(tree, this);
                case ASTreeTypes.PRIMITIVE_TYPE:
                    return ((JavaModelPackage) refImmediatePackage()).getType().resolve(getName());
                default:
                    throw new IllegalArgumentException("Illegal tree type " + tree.getType() + "."); // NOI18N
            }
        }
    }

    /**
     * Creates a copy of this MultipartId instance
     */
    public Element duplicate(JavaModelPackage targetExtent) {
        return targetExtent.getMultipartId().createMultipartId(
            getName(),
            (MultipartId) duplicateElement(getParent(), targetExtent),
            duplicateList(getTypeArguments(), targetExtent)
        );
    }

    protected void _delete() {
        // --- delete components -------------------------------------------
        if (childrenInited) {
            deleteChildren(typeArguments);
        }
        // --- delete links -----------------------------------------------
        // no links to delete
        // --- call super ---------------------------------------
        super._delete();
    }

    public void replaceChild(Element oldElement,Element newElement) {
        if (childrenInited) {
            if (replaceObject(getTypeArguments(),oldElement,newElement)) return;
            super.replaceChild(oldElement,newElement);
        }
    }

    public List getChildren() {
        List list = super.getChildren();
        list.addAll(getTypeArguments());
        return list;
    }

    public void fixImports(Element scope, Element original) {
        MultipartId mpi=(MultipartId)original;
        TypeReference resolved=JavaModelUtil.resolveImportsForType(scope,(Type)mpi.getElement());
        
        if (resolved!=null) {
            setName(resolved.getName());
            setParent(null);
        }
        fixImports(scope,getTypeArguments(),((MultipartId)original).getTypeArguments());
    }

}
