/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.javacore.jmiimpl.javamodel;

import org.netbeans.jmi.javamodel.*;
import org.netbeans.mdr.storagemodel.StorableClass;
import java.util.List;



/**
 *
 * @author  mm109185
 */
public abstract class MultipartIdClassImpl extends MEFactory implements MultipartIdClass {
    
    /** Creates a new instance of MultipartIdClassImpl */
    public MultipartIdClassImpl(StorableClass s) {
        super(s);
    }
    
    /**
     * The default factory operation used to create an instance object.
     * @return The created instance object.
     */
    public MultipartId createMultipartId() {
        return createMPID(null, null, null);
    }
    
    private MultipartIdImpl createMPID(String name, MultipartId parent, List typeArguments) {
        MultipartIdImpl result = (MultipartIdImpl) create(null);
        result.setNew();
        result.setData(name, parent, typeArguments);
        return result;
    }

    public MultipartId createMultipartId(java.lang.String name, MultipartId parent, List typeArguments) {
        return createMPID(name, parent, typeArguments);
    }
}
