/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.javacore.jmiimpl.javamodel;

import java.util.*;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.MethodInvocation;
import org.netbeans.jmi.javamodel.PrimaryExpression;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.MethodInvocationClass;
import org.netbeans.lib.java.parser.ASTree;
import org.netbeans.lib.java.parser.ASTreeTypes;
import org.netbeans.mdr.storagemodel.StorableObject;
import org.netbeans.modules.javacore.parser.ASTProvider;


/**
 *
 * @author  Martin Matula
 */
public abstract class MethodInvocationImpl extends InvocationImpl implements MethodInvocation {
    private boolean hasSuper = false;
    private PrimaryExpression parentClass;
    
    /** Creates a new instance of MethodInvocationImpl */
    public MethodInvocationImpl(StorableObject o) {
        super(o);
    }
    
    public void setParentClass(PrimaryExpression expression) {
        objectChanged(CHANGED_PARENT_CLASS);
        changeChild(getParentClass(), expression);
        this.parentClass = expression;
    }
    
    public PrimaryExpression getParentClass() {
        if (!childrenInited) {
            initChildren();
        }
        return parentClass;
    }
    
    public boolean getHasSuper() {
        if (isChanged(CHANGED_HAS_SUPER)) {
            return hasSuper;
        } else {
            return getASTree().getSubTrees()[1] != null;
        }
    }
    
    public void setHasSuper(boolean hasSuper) {
        objectChanged(CHANGED_HAS_SUPER);
        this.hasSuper = hasSuper;
    }
    
    public List getChildren() {
        List list = new ArrayList();
        addIfNotNull(list, getParentClass()); 
        list.addAll(super.getChildren());
        return list;
    }
    
    protected void initChildren() {
        childrenInited = false;
        ASTree tree = getASTree();
        if (tree != null) {
            ASTree[] parts = tree.getSubTrees();
            parentClass = (PrimaryExpression) initOrCreate(parentClass, parts[0]);
            parameters = createChildrenList(parameters, "parameters", parts[4], ASTreeTypes.ARGUMENT_LIST, CHANGED_PARAMETERS, false); // NOI18N
        }
        childrenInited = true;
    }
    
     /**
     * Returns the value of reference type.
     * @return Value of reference type.
     */
    public Type getType() {
        Object semInfo = getParser().getSemanticInfo(getASTree(), this);
        
        if (semInfo instanceof Method)
            return ((Method)semInfo).getType();
        return null;
    }
    
    String getRawText() {
        StringBuffer buf = new StringBuffer();
        boolean hasSuper = getHasSuper ();
        StatementImpl parentClass = (StatementImpl) getParentClass();
        List params = getParameters();
        String methodName = getName();
        if (parentClass != null) {
            buf.append(parentClass.getSourceText());
            buf.append("."); // NOI18N
        }
        if (hasSuper) {
            buf.append("super."); // NOI18N
        }
        buf.append(methodName);
        // trees
        ASTree tree = getASTree();
        if (tree != null && tree.getSubTrees()[3] != null) {
            IndentUtil.printTokenWithAllAround(tree.getSubTrees()[3].getLastToken()+1, getASTree().getFirstToken(), this, buf);
        } else {
            formatElementPart(STMT_OPEN_BRACKET, buf);
        }
        Iterator iter = params.iterator();
        while (iter.hasNext()) {
            StatementImpl par = (StatementImpl) iter.next();
            buf.append(par.getSourceText());
            if (iter.hasNext()) {
                ASTree t = par.getASTree();
                if (t != null) {
                    int commaToken = t.getLastToken() + 1;
                    IndentUtil.printTokenWithAllAround(commaToken, getASTree().getFirstToken(), this, buf);
                } else {
                    formatElementPart(MetadataElement.COMMA, buf);
                }
            }
        }
        if (tree != null) {
            IndentUtil.printTokenWithAllAround(tree.getLastToken(), getASTree().getFirstToken(), this, buf);
        } else {
            formatElementPart(STMT_CLOSE_BRACKET, buf);
        }
        return buf.toString();
    }

    public void getDiff(List diff) {
        ASTProvider parser = getParser();
        ASTree tree = getASTree();
        ASTree[] children = tree.getSubTrees();
        
        if (isChanged(CHANGED_HAS_SUPER)) {
            int endOffset = parser.getToken(children[3].getFirstToken()-1).getEndOffset();
            int startOffset = children[0]!=null?parser.getToken(children[1].getLastToken()).getEndOffset():endOffset;
            diff.add(new DiffElement(startOffset, endOffset, isHasSuper()?"super":"")); //NOI18N
        }
        
        MetadataElement parentClass = (MetadataElement) getParentClass();
        if (isChanged(CHANGED_PARENT_CLASS) || (parentClass != null && parentClass.isChanged())) {
            getChildDiff(diff, parser, children[0], parentClass, CHANGED_PARENT_CLASS);
            //replaceNode(diff, parser, tree, getSourceText(), 0, null);
        }
        if (isChanged(CHANGED_NAME)) {
            replaceNode(diff, parser, children[3], getName(), 0, null);
        }
        getCollectionDiff(diff, parser, CHANGED_PARAMETERS, children[4], ASTreeTypes.ARGUMENT_LIST, getParameters(), 
            parser.getToken(tree.getLastToken()).getStartOffset(), formatElementPart(MetadataElement.COMMA));
}
    
    void setData(String name, List parameters, PrimaryExpression parentClass, boolean hasSuper) {
        setData(name, parameters);
        changeChild(null, parentClass);
        this.parentClass = parentClass;
        this.hasSuper = hasSuper;
    }

    protected ASTree getNameAST() {
        return getASTree().getSubTrees()[3];
    }

    protected void _delete() {
        // --- delete components -------------------------------------------
        if (childrenInited) {
            deleteChild(parentClass);
        }
        // --- delete links -----------------------------------------------
        // no links to delete
        // --- call super ---------------------------------------
        super._delete();
    }
    
    public void replaceChild(Element oldElement,Element newElement) {
        if (childrenInited) {
            if (oldElement.equals(parentClass)) {
                setParentClass((PrimaryExpression)newElement);
            } else
                super.replaceChild(oldElement,newElement);
        }
    }
    
    public Element duplicate(JavaModelPackage targetExtent) {
        return targetExtent.getMethodInvocation().createMethodInvocation(
                getName(),
                duplicateList(getParameters(), targetExtent), 
                (PrimaryExpression) duplicateElement(getParentClass(), targetExtent),
                getHasSuper()
               );
    }

    protected String getIndentation() {
        return ((MetadataElement) refImmediateComposite()).getIndentation();
    }
}
