/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.javacore.jmiimpl.javamodel;

import org.netbeans.api.mdr.MDRObject;
import org.netbeans.jmi.javamodel.Feature;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.mdr.handlers.ClassProxyHandler;
import org.netbeans.mdr.storagemodel.StorableClass;
import javax.jmi.model.MofClass;
import javax.jmi.reflect.RefObject;
import java.lang.ref.WeakReference;
import java.util.*;


/** Root class for class proxies of classes that have transient or partially persistent
 * instances. This class universally implements refAllOfType and refAllOfClass operations.
 *
 * @author Martin Matula    
 */
public abstract class MetadataElementClass extends ClassProxyHandler {
    private WeakReference allOfClass = null;
    private WeakReference allOfType = null;
    
    /** Creates a new instance of SemiPersistentClass */
    public MetadataElementClass(StorableClass s) {
        super(s);
    }
    
    protected boolean _pushIterators(Collection iterators, Object obj, boolean includeSupertypes) {
        boolean pushed = false;
        if (obj == null)
            return pushed;
        
//        if (obj instanceof Resource) {
//            iterators.add(((Resource) obj).getClassifiers().iterator());
//            iterators.add(((Resource) obj).getImports().iterator());
//        } else if (obj instanceof ClassDefinition) {
//            iterators.add(((ClassDefinition) obj).getFeatures().iterator());
//        } else if (obj instanceof CallableFeature) {
//            iterators.add(((CallableFeature) obj).getParameters().iterator());
//        } else {
//            pushed = false;
//        }
//        
//        if (obj instanceof Feature) {
//            JavaDoc javaDoc = ((Feature)obj).getJavadoc();
//            List tags = (javaDoc != null) ? javaDoc.getTags() : null;
//            if (tags != null && !tags.isEmpty()) {
//                iterators.add(tags.iterator());
//                pushed = true;
//            }
//        }
        if (obj instanceof MetadataElement) {
            Collection children = ((MetadataElement) obj).getChildren();
            if (children != null && !children.isEmpty()) {
                iterators.add(children.iterator());
                pushed = true; 
            }
        }
        else if (obj instanceof List) {
            iterators.add(((List) obj).iterator());
            pushed = true; 
        }
        
        return pushed;
    }

    protected boolean _accept(Object obj, boolean includeSupertypes) {
        if (obj == null || !(obj instanceof RefObject))
            return false;
        return ((RefObject) obj).refIsInstanceOf(refMetaObject(), includeSupertypes);
    }

    protected boolean _isAbstract() {
        return ((MofClass) refMetaObject()).isAbstract();
    }
    
    protected Collection _allOfClass(boolean includeSubtypes) {
        // [TODO] include also new elements that have not been added to any resource yet
        // they can be found in the registry of new elements
        Collection result;
        if (includeSubtypes) {
            if (allOfType == null || (result = (Collection) allOfType.get()) == null) {
                result = new AllOfClassCollection(true, (JavaModelPackage) refImmediatePackage());
                allOfType = new WeakReference(result);
            }
        } else {
            if (_isAbstract()) {
                result = Collections.EMPTY_LIST;
            } else {
                if (allOfClass == null || (result = (Collection) allOfClass.get()) == null) {
                    result = new AllOfClassCollection(false, (JavaModelPackage) refImmediatePackage());
                    allOfClass = new WeakReference(result);
                }
            }
        }
        return result;
    }
    
    private class AllOfClassCollection extends AbstractCollection {
        private final boolean includeSubtypes;
        private final JavaModelPackage extent;
        
        public AllOfClassCollection(boolean includeSubtypes, JavaModelPackage extent) {
            this.includeSubtypes = includeSubtypes;
            this.extent = extent;
        }
        
        public Iterator iterator() {
            return new It();
        }
        
        public int size() {
            lock();
            try {
                int size = 0;
                for (Iterator it = iterator(); it.hasNext(); it.next(), size++);
                return size;
            } finally {
                unlock();
            }
        }
        
        private void lock() {
            ((MDRObject) extent).repository().beginTrans(false);
        }
        
        private void unlock() {
            ((MDRObject) extent).repository().endTrans();
        }
        
        private class It implements Iterator {
            private final List iterators = new ArrayList();
            private Iterator currentIterator;
            private Object lastItem = null;
            
            public It() {
                currentIterator = extent.getResource().refAllOfClass().iterator();
            }
            
            public boolean hasNext() {
                while (lastItem == null && (!iterators.isEmpty() || currentIterator.hasNext())) {
                    while (lastItem == null && currentIterator.hasNext()) {
                        Object temp = currentIterator.next();
                        if (_pushIterators(iterators, temp, includeSubtypes)) {
                            iterators.add(currentIterator);
                            currentIterator = (Iterator) iterators.remove(0);
                        }
                        if (_accept(temp, includeSubtypes)) {
                            lastItem = temp;
                        }
                        else if (temp instanceof Feature && _accept(((Feature)temp).getJavadoc(), includeSubtypes)) {
                            lastItem = ((Feature)temp).getJavadoc();
                        }
                    }
                    if (lastItem == null) {
                        currentIterator = (Iterator) iterators.remove(0);
                    }
                }
                return lastItem != null;
            }
            
            public Object next() {
                lock();
                try {
                    if (hasNext()) {
                        Object result = lastItem;
                        lastItem = null;
                        return result;
                    } else {
                        throw new NoSuchElementException();
                    }
                } finally {
                    unlock();
                }
            }
            
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }
}
