/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.javacore.jmiimpl.javamodel;

import java.util.*;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.LabeledStatement;
import org.netbeans.jmi.javamodel.Statement;
import org.netbeans.lib.java.parser.ASTree;
import org.netbeans.mdr.storagemodel.StorableObject;
import org.netbeans.modules.javacore.parser.ASTProvider;
import org.netbeans.modules.javacore.parser.ASTUtil;

/**
 *
 * @author  Martin Matula
 */
public abstract class LabeledStatementImpl extends StatementImpl implements LabeledStatement {
    private String label = null;
    private Statement body = null;
    
    /** Creates a new instance of LabeledStatementImpl */
    public LabeledStatementImpl(StorableObject o) {
        super(o);
    }
    
    public void setLabel(String label) {
        objectChanged(CHANGED_LABEL);
        this.label = label;
    }
    
    public String getLabel() {
        if (isChanged(CHANGED_LABEL)) {
            return label;
        } else {
            return ASTUtil.getIdentifier(getASTree().getSubTrees()[0]);
        }
    }
    
    public void setBody(Statement body) {
        objectChanged(CHANGED_BODY);
        changeChild(getBody(), body);
        this.body = body;
    }

    public List getChildren() {
        List list = new ArrayList(1);
        addIfNotNull(list, getBody()); 
        return list;
    }
    
    protected void initChildren() {
        childrenInited = false;
        ASTree tree = getASTree();
        if (tree != null) {
            body = (Statement) initOrCreate(body, getASTree().getSubTrees()[1]);
        }
        childrenInited = true;
    }
    
    public Statement getBody() {
        if (!childrenInited) {
            initChildren();
        }
        return body;
    }
    
    String getRawText() {
        StringBuffer buf = new StringBuffer();
        StatementImpl body = (StatementImpl)getBody();
        String label = getLabel();
        buf.append(label);
        buf.append(": "); // NOI18N
        buf.append(body.getSourceText());
        return buf.toString();
    }
        
    public void getDiff(List diff) {
        ASTProvider parser = getParser();
        ASTree tree = getASTree();
        ASTree[] children = tree.getSubTrees();
        
        if (isChanged(CHANGED_LABEL)) {
            replaceNode(diff, parser, children[0], getLabel(), 0, null);
        }
        getChildDiff(diff, parser, children[1], (MetadataElement) getBody(), CHANGED_BODY);
    }
    
    void setData(String label, Statement body) {
        this.label = label;
        changeChild(null, body);
        this.body = body;
    }

    protected void _delete() {
        // --- delete components -------------------------------------------
        if (childrenInited) {
            deleteChild(body);
        }
        // --- delete links -----------------------------------------------
        // no links to delete
        // --- call super ---------------------------------------
        super._delete();
    }
    
    public void replaceChild(Element oldElement,Element newElement) {
        if (childrenInited) {
            if (oldElement.equals(body)) {
                setBody((Statement)newElement);
            }
        }
    }
    
    public Element duplicate(JavaModelPackage targetExtent) {
        return targetExtent.getLabeledStatement().createLabeledStatement(
                getLabel(),
                (Statement) duplicateElement(getBody(), targetExtent)
               );
    }
}
