/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.javacore.jmiimpl.javamodel;

import java.util.*;
import javax.jmi.reflect.ConstraintViolationException;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.JavaPackage;
import org.netbeans.jmi.javamodel.JavaPackageClass;
import org.netbeans.mdr.handlers.ClassProxyHandler;
import org.netbeans.mdr.persistence.MOFID;
import org.netbeans.mdr.persistence.StorageException;
import org.netbeans.mdr.storagemodel.StorableBaseObject;
import org.netbeans.mdr.storagemodel.StorableClass;
import org.netbeans.mdr.storagemodel.StorableObject;
import org.netbeans.mdr.util.DebugException;
import org.netbeans.modules.javacore.JMManager;
import org.openide.ErrorManager;

/**
 *
 * @author  Martin Matula
 */
public abstract class JavaPackageClassImpl extends ClassProxyHandler implements JavaPackageClass {
    private static final String MOFID_PREFIX = "package:"; // NOI18N
    private static final HashMap allInstances = new HashMap();
    
    private static JavaPackageClassImpl mainProxy = null;
    
    private static JavaPackageClassImpl getMainProxy() {
        // initialize the "main" class proxy  - the class proxy that the "proxy" packages will be associated with
        // (it will be the class proxy for the JavaPackage class for the default filesystem
        // codebase)
        if (mainProxy == null) {
            JavaModelPackage pkg = org.netbeans.modules.javacore.internalapi.JavaMetamodel.getManager().getDefaultExtent();
            mainProxy = (JavaPackageClassImpl) pkg.getJavaPackage();
        }
        return mainProxy;
    }

    static void removePackage(JavaPackage pkg) {
        allInstances.remove(pkg.getName());
    }
    
    /** Creates a new instance of PackageClassImpl */
    public JavaPackageClassImpl(StorableClass s) {
        super(s);
    }
    
    public JavaPackage createJavaPackage(String name, List annotations) {
        throw new UnsupportedOperationException("Cannot explicitly create a package."); // NOI18N
    }
    
    protected abstract JavaPackage super_createJavaPackage(String name, List annotations);
    
    public JavaPackage createJavaPackage() {
        throw new ConstraintViolationException(this, refMetaObject(), "Cannot create package without a name."); // NOI18N
    }
    
    public JavaPackage resolvePackage(String name, boolean forceInclude) {
        // if this is not the main proxy, delegate the call to the main proxy
        if (getMainProxy() != this) {
            return getMainProxy().resolvePackage(name, forceInclude);
        }
        JavaPackageImpl result = (JavaPackageImpl) allInstances.get(name);
        return (forceInclude || (result != null && result.shouldInclude())) ? result : null;
    }

    public JavaPackage resolvePackage(String name) {
        repository().beginTrans(false);
        try {
            boolean force = false;
            if (getMainProxy() != this) {
                force = (findRealPackage(name) != null);
            }
            return resolvePackage(name, force);
        } finally {
            repository().endTrans();
        }
    }

    JavaPackageImpl resolveOrCreatePackage(String name) {
        JavaPackageImpl result = (JavaPackageImpl) allInstances.get(name);
        if (result == null) {
            try {
                JavaPackageImpl parent = null;
                if (name.length() > 0) {
                    int index = name.lastIndexOf('.');
                    String parentName = index > 0 ? name.substring(0, index) : "";
                    parent = resolveOrCreatePackage(parentName);
                }
                StorableBaseObject s = _getDelegate();
                MOFID mofId = new MOFID(name.hashCode(), MOFID_PREFIX + name);
                DeferredObject o = new DeferredObject(mofId, s.getMdrStorage(), s.getImmediatePackageId(), s.getOutermostPackageId(), s.getMetaObject(), (StorableClass) s, parent == null ? null : (StorableObject) parent._getDelegate());
                result = (JavaPackageImpl) _getRepository().getHandler(o);
                result.name = name;
                allInstances.put(name, result);
                if (parent != null) {
                    parent.addSubPackage(result);
                }
//                System.out.println("adding package: " + name);
                // add to the parent package
            } catch (StorageException e) {
                throw new DebugException();
            }
        }
        return result;
    }
    
    JavaPackage resolveRealPackage(String name) {
        if (name == null) return null;
        JavaPackageImpl result = findRealPackage(name);
        if (result == null) {
            result = (JavaPackageImpl) super_createJavaPackage(name, null);
            if (name.length() > 0) {
                int index = name.lastIndexOf('.');
                String parentName = index > 0 ? name.substring(0, index) : "";
                JavaPackageImpl parent = (JavaPackageImpl) resolveRealPackage(parentName);
                if (parent == null) {
                    throw new IllegalStateException("parent package for " + name + " not found."); // NOI18N
                }
                parent.addSubPackage(result);
            }
            addRealPackage(result);
        }
        return result;
    }

    public JavaPackageImpl findRealPackage(String name) {
        StorableBaseObject storable = _getDelegate();
        Collection col = storable.getMdrStorage().getObjectsFromAdditionalIndex(storable.getImmediatePackageId(), "Package.name", name); // NOI18N
        return col == null || col.isEmpty() ? null : (JavaPackageImpl) _getRepository().getHandler((StorableBaseObject) col.iterator().next());
    }

    void removeRealPackage(JavaPackageImpl realPackage) {
        JavaPackageImpl result = (JavaPackageImpl) resolvePackage(realPackage.getName(), true);
        if (result != null) {
            result.removeRealPackage(realPackage);
        } else {
            JMManager.getLog().log(ErrorManager.WARNING, "proxy package for package " + realPackage.getName() + " not found.");
        }
    }
    
    void addRealPackage(JavaPackageImpl realPackage) {
        if (getMainProxy() != this) {
            getMainProxy().addRealPackage(realPackage);
            return;
        }
        String name = realPackage.getName();
        JavaPackageImpl result = resolveOrCreatePackage(name);
        result.addRealPackage(realPackage);
    }
    
    public void addAllRealPackages() {
        for (Iterator it = super._allOfClass(false).iterator(); it.hasNext();) {
            addRealPackage((JavaPackageImpl) it.next());
        }
    }
    
    public void removeAllRealPackages() {
        for (Iterator it = super._allOfClass(false).iterator(); it.hasNext();) {
            removeRealPackage((JavaPackageImpl) it.next());
        }
    }
    
    protected Collection _allOfClass(boolean recursive) {
        return Collections.unmodifiableCollection(allInstances.values());
    }
}
