/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.javacore.jmiimpl.javamodel;

import java.util.List;
import org.netbeans.jmi.javamodel.*;
import org.netbeans.mdr.handlers.ClassProxyHandler;
import org.netbeans.mdr.persistence.StorageException;
import org.netbeans.mdr.storagemodel.StorableBaseObject;
import org.netbeans.mdr.storagemodel.StorableClass;
import org.netbeans.modules.javacore.ClassIndex;

/**
 *
 * @author Martin Matula
 */
public abstract class JavaEnumClassImpl extends ClassProxyHandler implements JavaEnumClass {
// [TODO] this class should probably extend SemiPersistentClass, since not all enumerations
// are persistent (local enumerations are not)
    
    /** Creates a new instance of JavaClassClassImpl */
    public JavaEnumClassImpl(StorableClass s) {
        super(s);
    }
    
    /**
     * The default factory operation used to create an instance object.
     * @return The created instance object.
     */
    public JavaEnum createJavaEnum() {
        return create(null, null, 0, null, null, null, null, null);
    }
    
    public JavaEnum createJavaEnum(String name, List annotations, int modifiers, String javadocText, JavaDoc javadoc, List features, MultipartId superClassName, List interfaceNames, List typeArguments, List constants) {
        return create(name, annotations, modifiers, javadocText, javadoc, features, interfaceNames, constants);
    }
    
    protected abstract JavaEnum super_createJavaEnum(String name, List annotations, int modifiers, String javadocText, JavaDoc javadoc, List features, MultipartId superClassName, List interfaceNames, List typeArguments, List constants);
    protected abstract JavaEnum super_createJavaEnum();
    
    private JavaEnumImpl create(String name, List annotations, int modifiers, String javadocText, JavaDoc javadoc, List features, List interfaceNames, List constants) {
        boolean fail = true;
        _lock(true);
        try {
            JavaEnumImpl result = create(name, modifiers, false);
            result.setNew();
            result.setData(annotations, javadocText, javadoc, constants, features, interfaceNames);
            fail = false;
            return result;
        } finally {
            _unlock(fail);
        }
    }

    protected SemiPersistentElement createTransient() {
        try {
            StorableBaseObject s = _getDelegate();
            DeferredObject o = new DeferredObject(null, s.getMdrStorage(), s.getImmediatePackageId(), s.getOutermostPackageId(), s.getMetaObject(), (StorableClass) s, null, true);
            SemiPersistentElement result = (SemiPersistentElement) _getRepository().getHandler(o);
            return result;
        } catch (StorageException e) {
            throw new RuntimeException();
        }
    }

    public JavaEnumImpl create(String name, int modifiers, boolean isTransient) {
        JavaEnumImpl result;
        if (isTransient) {
            result = (JavaEnumImpl) createTransient();
            boolean changes = result.disableChanges;
            result.disableChanges = true;
            try {
                result.setName(name);
                result.setModifiers(modifiers);
            } finally {
                result.disableChanges = changes;
            }
        } else {
            result = (JavaEnumImpl) super_createJavaEnum(name, null, modifiers, null, null, null, null, null, null, null);
            if (name != null) {
                JavaModelPackage srcExtent = (JavaModelPackage) refImmediatePackage();
                ClassIndex index = ClassIndex.getIndex(srcExtent);
                index.addClass(result, name, result.getSimpleName());
            }
        }
        return result;
    }
    
    public org.netbeans.jmi.javamodel.Type resolve(java.lang.String name) {
        JavaModelPackage pkg = (JavaModelPackage) refImmediatePackage();
        return pkg.getType().resolve(name);
    }
}
