/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *  
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *  
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.javacore.jmiimpl.javamodel;

import java.util.List;

import org.netbeans.jmi.javamodel.JavaDoc;
import org.netbeans.jmi.javamodel.JavaDocClass;
import org.netbeans.mdr.persistence.StorageException;
import org.netbeans.mdr.storagemodel.StorableClass;
import org.openide.ErrorManager;


/**
 * Implementation of JavaDoc class proxy interface.
 *
 * @author Vladimir Hudec
 */
public abstract class JavaDocClassImpl extends MEFactory implements JavaDocClass {
    
    protected JavaDocClassImpl(StorableClass s) {
        super(s);
    }
    
    /**
     * The default factory operation used to create an instance object.
     * @return The created instance object.
     */
    public JavaDoc createJavaDoc() {
        return create(null, null);
    }

    /**
     * Creates an instance object having attributes initialized by the passed 
     * values.
     * @param text 
     * @param tags 
     * @return The created instance object.
     */
    public JavaDoc createJavaDoc(String text, List tags) {
        return create(text, tags);
    }

    /** This method is not based on an officialy declared metamodel inteface 
     */
    private JavaDocImpl create(String text, List tags) {
        JavaDocImpl result = (JavaDocImpl) create(null);
        result.setNew();
        result.setData(text, tags);
        return result;
    }
}
