/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.javacore.jmiimpl.javamodel;

import java.util.Arrays;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.jmi.javamodel.*;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.mdr.handlers.ClassProxyHandler;
import org.netbeans.mdr.storagemodel.StorableClass;
import org.netbeans.mdr.storagemodel.StorableBaseObject;
import org.netbeans.mdr.persistence.StorageException;
import org.netbeans.modules.javacore.ClassIndex;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import java.util.List;
import org.netbeans.modules.javacore.parser.NameRef;

/**
 *
 * @author  Martin Matula
 */
public abstract class JavaClassClassImpl extends ClassProxyHandler implements JavaClassClass {
// [TODO] this class should probably extend SemiPersistentClass, since not all JavaClasses
// are persistent (local classes are not)
    
    /** Creates a new instance of JavaClassClassImpl */
    public JavaClassClassImpl(StorableClass s) {
        super(s);
    }
    
    /**
     * The default factory operation used to create an instance object.
     * @return The created instance object.
     */
    public JavaClass createJavaClass() {
        return create(null, null, 0, null, null, null, null, null, null);
    }
    
    public JavaClass createJavaClass(java.lang.String name, List annotations, int modifiers, java.lang.String javadocText, JavaDoc javadoc, List features, MultipartId superClassName, List interfaceNames, List typeArguments) {
        return create(name, annotations, modifiers, javadocText, javadoc, features, superClassName, interfaceNames, typeArguments);
    }
    
    protected abstract JavaClass super_createJavaClass(java.lang.String name, List annotations, int modifiers, java.lang.String javadocText, JavaDoc javadoc, List features, MultipartId superClassName, List interfaceNames, List typeArguments);
    protected abstract JavaClass super_createJavaClass();
    
    private JavaClassImpl create(java.lang.String name, List annotations, int modifiers, java.lang.String javadocText, JavaDoc javadoc, List features, MultipartId superClassName, List interfaceNames, List typeArguments) {
        boolean fail = true;
        _lock(true);
        try {
            JavaClassImpl result = create(name, modifiers, (NameRef) SemiPersistentElement.typeReferenceToTypeRef(superClassName, 0), interfaceNames == null ? null : (NameRef[]) SemiPersistentElement.typeReferencesToTypeRef(interfaceNames).toArray(new NameRef[interfaceNames.size()]), false);
            result.setNew();
            result.setData(annotations, javadocText, javadoc, features, superClassName, interfaceNames, typeArguments);
            fail = false;
            return result;
        } finally {
            _unlock(fail);
        }
    }

    protected SemiPersistentElement createTransient() {
        try {
            StorableBaseObject s = _getDelegate();
            DeferredObject o = new DeferredObject(null, s.getMdrStorage(), s.getImmediatePackageId(), s.getOutermostPackageId(), s.getMetaObject(), (StorableClass) s, null, true);
            SemiPersistentElement result = (SemiPersistentElement) _getRepository().getHandler(o);
            return result;
        } catch (StorageException e) {
            throw new RuntimeException();
        }
    }

    public JavaClassImpl create(String name, int modifiers, NameRef superclass, NameRef[] interfaces, boolean isTransient) {
        JavaClassImpl result;
        if (isTransient) {
            result = (JavaClassImpl) createTransient();
            boolean changes = result.disableChanges;
            result.disableChanges = true;
            try {
                result.setName(name);
                result.setModifiers(modifiers);
            } finally {
                result.disableChanges = changes;
            }
        } else {
            result = (JavaClassImpl) super_createJavaClass(name, null, modifiers, null, null, null, null, null, null);
            if (name != null) {
                JavaModelPackage srcExtent = (JavaModelPackage) refOutermostPackage();
                ClassIndex index = ClassIndex.getIndex(srcExtent);
                index.addClass(result, name, result.getSimpleName());
                //System.out.println("Class created: " + name + " MOFID: " + result.refMofId());
                //Thread.dumpStack();
            }
        }
        result.setSuperclassRef(superclass);
        result.setInterfaceRefs(interfaces == null ? null : Arrays.asList(interfaces));
        return result;
    }

    /**
     *
     * @param name
     * @param onlyResolved If true, then this method will return null (instead of UnresolvedClass) if the classname is not resolved.
     * @return
     */
    public JavaClass resolveClass(String name, boolean onlyResolved) {
        if (name == null) return null;
        _lock(false);
        try {
            ClassPath cp = JavaMetamodel.getManager().getClassPath();
            JavaClass result = ClassIndex.getClassByFqn(name,cp);
            if (result == null && !onlyResolved) {
                // class was not found - create UnresolvedClass
                UnresolvedClassClassImpl cls = (UnresolvedClassClassImpl) JavaMetamodel.getManager().getDefaultExtent().getUnresolvedClass();
                result = cls.resolveUnresolved(name);
            }
            return result;
        } finally {
            _unlock();
        }
    }
    
    public org.netbeans.jmi.javamodel.Type resolve(java.lang.String name) {
        JavaModelPackage pkg = (JavaModelPackage) refImmediatePackage();
        return pkg.getType().resolve(name);
    }
}
