/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.javacore.jmiimpl.javamodel;

import org.netbeans.jmi.javamodel.Initializer;
import org.netbeans.jmi.javamodel.InitializerClass;
import org.netbeans.jmi.javamodel.JavaDoc;
import org.netbeans.jmi.javamodel.StatementBlock;
import org.netbeans.mdr.storagemodel.StorableClass;
import java.util.List;

/**
 * Implementation of Initializer class proxy interface.
 *
 * @author Martin Matula, Vladimir Hudec
 */
public abstract class InitializerClassImpl extends SemiPersistentClass implements InitializerClass {
    
    protected InitializerClassImpl(StorableClass s) {
        super(s);
    }
    
    /**
     * The default factory operation used to create an instance object.
     * @return The created instance object.
     */
    public Initializer createInitializer() {
        return create(null, 0, null, null, null, null);
    }
    
    /**
     * Creates an instance object having attributes initialized by the passed 
     * values.
     * @param name 
     * @param annotations 
     * @param modifiers 
     * @param javadocText 
     * @param javadoc 
     * @param body 
     * @param bodyText 
     * @return The created instance object.
     */
    public Initializer createInitializer(java.lang.String name, List annotations, int modifiers, java.lang.String javadocText, JavaDoc javadoc, StatementBlock body, java.lang.String bodyText) {
        return create(annotations, modifiers, javadocText, javadoc, body, bodyText);
    }
    
    private Initializer create(List annotations, int modifiers, java.lang.String javadocText, JavaDoc javadoc, StatementBlock body, java.lang.String bodyText) {
        InitializerImpl result = create(modifiers, false);
        result.setNew();
        result.setData(annotations, javadocText, javadoc, body, bodyText);
        return result;
    }

    public InitializerImpl create(int modifiers, boolean isTransient) {
        if (isTransient) {
            InitializerImpl result = (InitializerImpl) createTransient();
            boolean changes = result.disableChanges;
            result.disableChanges = true;
            try {
                result.setModifiers(modifiers);
            } finally {
                result.disableChanges = changes;
            }
            return result;
        } else {
            return (InitializerImpl) super_createInitializer(null, null, modifiers, null, null, null, null);
        }
    }

    protected abstract Initializer super_createInitializer();
    protected abstract Initializer super_createInitializer(java.lang.String name, List annotations, int modifiers, java.lang.String javadocText, JavaDoc javadoc, StatementBlock body, java.lang.String bodyText);
}
