/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.javacore.jmiimpl.javamodel;

import java.util.*;
import org.netbeans.jmi.javamodel.*;
import org.netbeans.lib.java.parser.ASTree;
import org.netbeans.mdr.storagemodel.StorableObject;
import org.netbeans.modules.javacore.JMManager;
import org.netbeans.modules.javacore.parser.ASTProvider;

/**
 *
 * @author Martin Matula
 */
public abstract class InfixExpressionImpl extends ExpressionImpl implements InfixExpression {
    private Expression leftSide = null;
    private Operator operator = null;
    private Expression rightSide = null;
    
    /** Creates a new instance of InfixExpressionImpl */
    public InfixExpressionImpl(StorableObject o) {
        super(o);
    }
    
    public void setLeftSide(Expression expression) {
        objectChanged(CHANGED_LEFT_SIDE);
        changeChild(getLeftSide(), expression);
        this.leftSide = expression;
    }
    
    public Expression getLeftSide() {
        if (!childrenInited) {
            initChildren();
        }
        return leftSide;
    }
    
    public void setRightSide(Expression expression) {
        objectChanged(CHANGED_RIGHT_SIDE);
        changeChild(getRightSide(), expression);
        this.rightSide = expression;
    }
    
    public Expression getRightSide() {
        if (!childrenInited) {
            initChildren();
        }
        return rightSide;
    }
    
    public void setOperator(Operator operator) {
        objectChanged(CHANGED_OPERATOR);
        this.operator = operator;
    }
    
    public Operator getOperator() {
        if (isChanged(CHANGED_OPERATOR)) {
            return operator;
        } else {
            return getOperator(getASTree().getSubTrees()[1].getType());
        }
    }
    
    public List getChildren() {
        List list = new ArrayList(2);
        addIfNotNull(list, getLeftSide()); 
        addIfNotNull(list, getRightSide()); 
        return list;
    }
    
    protected void initChildren() {
        childrenInited = false;
        ASTree tree = getASTree();
        if (tree != null) {
            ASTree[] parts = tree.getSubTrees();
            leftSide = (Expression) initOrCreate(leftSide, parts[0]);
            rightSide = (Expression) initOrCreate(rightSide, parts[2]);
        }
        childrenInited = true;
    }
    
    public String getSourceText() {
        String origElem;
        if ((origElem = checkChange()) != null)
            return origElem;
        StringBuffer buf = new StringBuffer();
        StatementImpl leftSide = (StatementImpl) getLeftSide();
        StatementImpl rightSide = (StatementImpl) getRightSide();
        Operator operator = getOperator();
        buf.append(leftSide.getSourceText());
        buf.append(" "); // NOI18N
        buf.append(operatorToString(operator));
        buf.append(" "); // NOI18N
        buf.append(rightSide.getSourceText());
        return buf.toString();
    }

    public void getDiff(List diff) {
        ASTProvider parser = getParser();
        ASTree tree = getASTree();
        ASTree[] children = tree.getSubTrees();

        getChildDiff(diff, parser, children[0], (MetadataElement) getLeftSide(), CHANGED_LEFT_SIDE);
        if (isChanged(CHANGED_OPERATOR)) {
            replaceNode(diff, parser, children[1], operatorToString(getOperator()), 0, null);
        }
        getChildDiff(diff, parser, children[2], (MetadataElement) getRightSide(), CHANGED_RIGHT_SIDE);
    }
    
    private String operatorToString (Operator op) {
        if (op == OperatorEnum.GT) return ">"; // NOI18N
        if (op == OperatorEnum.LT) return "<"; // NOI18N
        if (op == OperatorEnum.EQUAL) return "=="; // NOI18N
        if (op == OperatorEnum.LTE) return "<="; // NOI18N
        if (op == OperatorEnum.GTE) return ">="; // NOI18N
        if (op == OperatorEnum.NEQUAL) return "!="; // NOI18N
        if (op == OperatorEnum.PLUS) return "+"; // NOI18N
        if (op == OperatorEnum.MINUS) return "-"; // NOI18N
        if (op == OperatorEnum.MULTI) return "*"; // NOI18N
        if (op == OperatorEnum.DIV) return "/"; // NOI18N
        if (op == OperatorEnum.LAND) return "&&"; // NOI18N
        if (op == OperatorEnum.LOR) return "||"; // NOI18N
        if (op == OperatorEnum.AND) return "&"; // NOI18N
        if (op == OperatorEnum.OR) return "|"; // NOI18N
        if (op == OperatorEnum.XOR) return "^"; // NOI18N
        if (op == OperatorEnum.MOD) return "%"; // NOI18N
        if (op == OperatorEnum.LSHIFT) return "<<"; // NOI18N
        if (op == OperatorEnum.RSHIFT) return ">>"; // NOI18N
        if (op == OperatorEnum.URSHIFT) return ">>>"; // NOI18N
        if (op == OperatorEnum.INSTANCEOF) return "instanceof"; // NOI18N
        
        JMManager.getLog().log("Operator not mapped to string: " + op); // [PENDING]
        return "???"; // NOI18N
    }
    
    void setData(Expression leftSide, Operator operator, Expression rightSide) {
        changeChild(null, leftSide);
        this.leftSide = leftSide;
        this.operator = operator;
        changeChild(null, rightSide);
        this.rightSide = rightSide;
    }

    protected void _delete() {
        // --- delete components -------------------------------------------
        if (childrenInited) {
            deleteChild(leftSide);
            deleteChild(rightSide);
        }
        // --- delete links -----------------------------------------------
        // no links to delete
        // --- call super ---------------------------------------
        super._delete();
    }
    
   public void replaceChild(Element oldElement,Element newElement) {
        if (childrenInited) {
            if (oldElement.equals(leftSide)) {
                setLeftSide((Expression)newElement);
            } else if (oldElement.equals(rightSide)) {
                setRightSide((Expression)newElement);
            }
        }
    }
   
    public Element duplicate(JavaModelPackage targetExtent) {
        return targetExtent.getInfixExpression().createInfixExpression(
                (Expression) duplicateElement(getLeftSide(), targetExtent),
                getOperator(),
                (Expression) duplicateElement(getRightSide(), targetExtent)
               );
    }
}
