/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.javacore.jmiimpl.javamodel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.netbeans.jmi.javamodel.GotoStatement;
import org.netbeans.lib.java.parser.ASTree;
import org.netbeans.mdr.storagemodel.StorableObject;
import org.netbeans.modules.javacore.parser.ASTProvider;
import org.netbeans.modules.javacore.parser.ASTUtil;

/**
 * Ancenstor of <code>break</code> and <code>continue</code> statements.
 *
 * @author  Martin Matula
 */
public abstract class GotoStatementImpl extends StatementImpl implements GotoStatement {
    private String label = null;
    
    /** Creates a new instance of GotoStatementImpl */
    public GotoStatementImpl(StorableObject o) {
        super(o);
    }
    
    public void setLabel(String label) {
        objectChanged(CHANGED_LABEL);
        this.label = label;
    }
    
    public String getLabel() {
        if (isChanged(CHANGED_LABEL)) {
            return label;
        } else {
            return ASTUtil.getIdentifier(getASTree().getSubTrees()[0]);
        }
    }
    
    protected abstract String getStatementName();
    
    String getRawText() {
        StringBuffer buf = new StringBuffer();
        buf.append(getStatementName());
        String label = getLabel();
        if (label != null) {
            buf.append(' ');
            buf.append(label);
        }            
        buf.append(';');            
        return buf.toString();
    }

    public void getDiff(List diff) {
        ASTProvider parser = getParser();
        ASTree tree = getASTree();
        ASTree[] children = tree.getSubTrees();
        
        if (isChanged(CHANGED_LABEL)) {
            replaceNode(diff, parser, children[0], getLabel(), parser.getToken(tree.getFirstToken()).getEndOffset(), " "); // NOI18N
        }
    }

    void setData(String label) {
        this.label = label;
    }
}
