/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.javacore.jmiimpl.javamodel;

import org.netbeans.jmi.javamodel.Expression;
import org.netbeans.jmi.javamodel.ForEachStatement;
import org.netbeans.jmi.javamodel.ForEachStatementClass;
import org.netbeans.jmi.javamodel.Parameter;
import org.netbeans.jmi.javamodel.Statement;
import org.netbeans.mdr.storagemodel.StorableClass;

/**
 * Factory class for creating ForEachStatement instances, i.e.
 * <code>
 * Collection<String> c = ...;
 * for (String s : c) {
 *    ...
 * }
 * </code>
 *
 * @author  Pavel Flaska
 */
public abstract class ForEachStatementClassImpl extends MEFactory implements ForEachStatementClass {
    
    /**
     * Creates a new instance of ForEachStatementClassImpl 
     *
     * @param c  creates handler for this storable
     */
    public ForEachStatementClassImpl(StorableClass c) {
        super(c);
    }
    
    /**
     * The default factory operation used to create an instance object.
     *
     * @return The created instance object.
     */
    public ForEachStatement createForEachStatement() {
        return create(null, null, null);
    }
    
    /**
     * Creates an instance object having attributes initialized by the passed 
     * values.
     * @param body       represents the body of the for loop element
     * @param parameter  
     * @param iterable 
     * @return The created instance object.
     */
    public ForEachStatement createForEachStatement(Statement body, Parameter parameter, Expression iterable)  {
        return create(body, parameter, iterable);
    }
    
    // .........................................................................
    // PRIVATE MEMBERS
    // .........................................................................
    private ForEachStatementImpl create(Statement body, Parameter parameter, Expression iterable) {
        ForEachStatementImpl result = (ForEachStatementImpl) create(null);
        result.setNew();
        result.setData(body, parameter, iterable);
        return result;
    }
}
