/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.javacore.jmiimpl.javamodel;

import org.netbeans.jmi.javamodel.FieldGroup;
import org.netbeans.jmi.javamodel.FieldGroupClass;
import org.netbeans.jmi.javamodel.TypeReference;
import org.netbeans.mdr.storagemodel.StorableClass;
import java.util.List;
import org.netbeans.modules.javacore.parser.TypeRef;

/**
 * Implementation of FieldGroupClass interface. Provides support for creation
 * FieldGroup. FieldGroup models field declarations such as 'int a, b;'.
 *
 * @author  Pavel Flaska
 */
public abstract class FieldGroupClassImpl extends SemiPersistentClass implements FieldGroupClass {

    protected FieldGroupClassImpl(StorableClass s) {
        super(s);
    }

    /**
     * The default factory operation used to create an instance object.
     *
     * @return The created instance object.
     */
    public FieldGroup createFieldGroup() {
        return create(0, null, null);
    }

    /**
     * The factory operation used to create an FieldGroup with specified
     * parameters.
     *
     * @param  modifiers  modifiers for the group of fields
     * @param  typeName   name of the type for the group of fields
     * @param  fields
     * @return The created instance object
     */
    public FieldGroup createFieldGroup(java.lang.String name, java.util.List annotations, int modifiers, java.lang.String javadocText, org.netbeans.jmi.javamodel.JavaDoc javadoc, org.netbeans.jmi.javamodel.TypeReference typeName, java.util.List fields) {
        return create(modifiers, typeName, fields);
    }

    public FieldGroupImpl create(int modifiers, TypeRef type, boolean isTransient) {
        FieldGroupImpl result;
        if (isTransient) {
            result = (FieldGroupImpl) createTransient();
            boolean changes = result.disableChanges;
            result.disableChanges = true;
            try {
                result.setModifiers(modifiers);
            } finally {
                result.disableChanges = changes;
            }
        } else {
            result = (FieldGroupImpl) super_createFieldGroup(null, null, modifiers, null, null, null, null);
        }
        result.setTypeRef(type);
        return result;
    }

    protected abstract FieldGroup super_createFieldGroup();
    protected abstract FieldGroup super_createFieldGroup(java.lang.String name, java.util.List annotations, int modifiers, java.lang.String javadocText, org.netbeans.jmi.javamodel.JavaDoc javadoc, org.netbeans.jmi.javamodel.TypeReference typeName, java.util.List fields);

    ////////////////////////////////////////////////////////////////////////////
    // PRIVATE MEMBERS
    ////////////////////////////////////////////////////////////////////////////
    private FieldGroup create(int modifiers, TypeReference typeName, List fields) {
        FieldGroupImpl result = create(modifiers, null, false);
        result.setNew();
        result.setData(typeName, fields);
        return result;
    }
}
