/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.javacore.jmiimpl.javamodel;

import org.netbeans.jmi.javamodel.Expression;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.mdr.storagemodel.StorableObject;

/**
 *
 * @author  Vladimir Hudec
 */
public abstract class ExpressionImpl extends StatementImpl {
    protected Type type;

    /** Creates a new instance of ExpressionImpl */
    public ExpressionImpl(StorableObject o) {
        super(o);
    }
    
    /**
     * Returns the value of reference type.
     * @return Value of reference type.
     */
    public Type getType() {
        if (isChanged(CHANGED_TYPE))
            return type;
        else {
            Object semInfo = getParser().getSemanticInfo(getASTree(), this);
            if (semInfo instanceof Type) {                
                return (Type) semInfo;
            } else if (semInfo instanceof String) {
                return ((JavaModelPackage) refImmediatePackage()).getType().resolve((String)semInfo);
            } else {
                return null;
            }
        }
    }

}
