/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.javacore.jmiimpl.javamodel;

import org.netbeans.jmi.javamodel.*;
import org.netbeans.mdr.storagemodel.StorableClass;
import java.util.List;

/**
 *
 * @author Martin Matula
 */
public abstract class EnumConstantClassImpl extends SemiPersistentClass implements EnumConstantClass {

    protected EnumConstantClassImpl(StorableClass s) {
        super(s);
    }

    public EnumConstant createEnumConstant() {
        return create(null, null, null, null, null, null, null);
    }

    public EnumConstant createEnumConstant(String name, List annotations, int modifiers, String javadocText, JavaDoc javadoc, boolean isFinal, TypeReference typeName, int dimCount, InitialValue initialValue, String initialValueText, ClassDefinition body) {
        return create(name, annotations, javadocText, javadoc, initialValue, initialValueText, body);
    }

    private EnumConstantImpl create(String name, List annotations, String javadocText, JavaDoc javadoc, InitialValue initialValue, String initialValueText, ClassDefinition body) {
        EnumConstantImpl result = create(name, false);
        result.setNew();
        result.setData(annotations, javadocText, javadoc, initialValue, initialValueText, body);
        return result;
    }

    public EnumConstantImpl create(String name, boolean isTransient) {
        if (isTransient) {
            EnumConstantImpl result = (EnumConstantImpl) createTransient();
            boolean changes = result.disableChanges;
            result.disableChanges = true;
            try {
                result.setName(name);
            } finally {
                result.disableChanges = changes;
            }
            return result;
        } else {
            return (EnumConstantImpl) super_createEnumConstant(name, null, 0, null, null, false, null, 0, null, null, null);
        }
    }

    protected abstract EnumConstant super_createEnumConstant();
    protected abstract EnumConstant super_createEnumConstant(String name, List annotations, int modifiers, String javadocText, JavaDoc javadoc, boolean isFinal, TypeReference typeName, int dimCount, InitialValue initialValue, String initialValueText, ClassDefinition body);
}
