/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.javacore.jmiimpl.javamodel;

import org.netbeans.jmi.javamodel.*;
import java.util.*;
import org.openide.text.PositionBounds;

/**
 * @author Jan Becicka
 */
public class ElementFinder {
    
    private Resource resource;
    
    public ElementFinder(Resource resource) {
        this.resource = resource;
    }
    
    public Element getElementByOffset(int position) {
        LinkedList queue = new LinkedList();  
        queue.addFirst(resource);
        Element last = resource;
        while (!queue.isEmpty()) {
            MetadataElement el = (MetadataElement) queue.removeLast();
            PositionBounds b = el.getPosition(false);
            if (b.getBegin().getOffset() <= position && b.getEnd().getOffset() > position) {
                last = el;
                Collection children = el.getChildren();
                if (children.isEmpty()) {
                    return el;
                }
                queue.addAll(children);
            }
        }
        return last;
    }

}
