/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.javacore.jmiimpl.javamodel;

/**
 * Represents one diff record in the source. Provides data structure for
 * creating diff list. Contains start offset of change, end offset and
 * the new text for this range.
 *
 * @author  Pavel Flaska
 */
public final class DiffElement {

    private final int startOffset;
    private final int endOffset;
    private final String text;

    /**
     * Instances represent one diff record. One instance defines range of
     * change in original source text and new text. Value cannot be null.
     *
     * @param startOffset where to start replacement
     * @param endOffset   where to end replacement
     * @param value       new text to use
     */    
    public DiffElement(int startOffset, int endOffset, String text) {
        //assert startOffset > endOffset : "startOffset > endOffset";
        //assert startOffset == endOffset && value.length() == 0 : "no operation";
        this.startOffset = startOffset;
        this.endOffset = endOffset;
        this.text = text;
    }

    /**
     * Getter for property startOffset.
     *
     * @return Value of property startOffset.
     */
    public int getStartOffset() {
        return startOffset;
    }    

    /**
     * Getter for property endOffset.
     *
     * @return Value of property endOffset.
     */
    public int getEndOffset() {
        return endOffset;
    }

    /**
     * Getter for property text.
     *
     * @return Value of property text.
     */
    public String getText() {
        return text;
    }

    /**
     * Returns true, if the record is newly inserted (i.e. it doesn't
     * replace anything in the original code).
     *
     * @return  true, if the diff is inserted code
     */
    public boolean isInserted() {
        return startOffset == endOffset;
    }
    
    /**
     *
     * @return true, if the diff is deleted code
     */
    public boolean isDeleted() {
        return startOffset < endOffset && text.length() == 0;
    }
}
