/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.javacore.jmiimpl.javamodel;

import java.util.*;

import javax.jmi.reflect.*;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.mdr.handlers.BaseObjectHandler;
import org.netbeans.mdr.persistence.MOFID;
import org.netbeans.mdr.persistence.StorageException;
import org.netbeans.mdr.storagemodel.*;
import org.netbeans.mdr.util.DebugException;
import org.openide.ErrorManager;

public class DeferredAttrList implements List {
    
    private List innerList;
    //private final Set innerSet; in new JavMetamodel we don't check for duplications
    
    private final StorableFeatured mdrObject;
//    private final StorableClass.AttributeDescriptor attrDesc;
    private final MOFID metaMofId;
    private final boolean isRefObject;
    
    public DeferredAttrList(StorableFeatured mdrObject, StorableClass.AttributeDescriptor attrDesc, List innerList) {
        this.mdrObject = mdrObject;
//        this.attrDesc = attrDesc;
        this.innerList = innerList;        
        metaMofId = attrDesc.getMofId();
        isRefObject = RefObject.class.isAssignableFrom(attrDesc.getType());
        
        //innerSet = new HashSet();
        setInnerList(innerList);
    }
    
    public void setInnerList(List innerList) {
        this.innerList = innerList;
//        //innerSet.clear();
//        Iterator iter = innerList.iterator();
//        while(iter.hasNext()) {
//            Object obj = iter.next();
//            if (!innerSet.add(obj)) {
////            //    throw new DuplicateException(obj, getMetaElement());
////            //}
////        } // while
    }

    // ..........................................................................
    
    private void setAttribComposite(RefObject object) {
        try {
            StorableObject storable = (StorableObject) ((BaseObjectHandler) object)._getDelegate();
            storable.setComposite(mdrObject, storable.getMofId(), metaMofId);
        } catch (StorageException e) {
            ErrorManager.getDefault().notify(e);
        }
    }
    
    private void clearAttribComposite(RefObject object) {
        try {
            StorableObject storable = (StorableObject) ((BaseObjectHandler) object)._getDelegate();
            storable.clearComposite();
        } catch (StorageException e) {
            ErrorManager.getDefault().notify(e);
        }
    }
    
//    private RefObject getMetaElement() {
//        try {
//            return (RefObject) mdrObject.getMdrStorage().getRepository().getHandler(mdrObject.getMdrStorage().getObject(metaMofId));
//        } catch (Exception e) {
//            return null;
//        }
//    }
    
    // ..........................................................................
    
    public boolean remove(Object obj) {
        boolean res = innerList.remove(obj);
        if (res) {
            //innerSet.remove(obj);
            if (isRefObject) {
                clearAttribComposite((RefObject) obj);
            }
        }
        return res;
    }
    
    public Object set(int param, Object obj) {
        Object old = innerList.set(param, obj);
        if (isRefObject) {            
            clearAttribComposite((RefObject) old);
            setAttribComposite((RefObject) obj);
        }
        //innerSet.remove(old);
        //if (!innerSet.add(obj)) {
        //    throw new DuplicateException(obj, getMetaElement());
        //}
        return old;
    }
    
    public Object remove(int param) {        
        Object old = innerList.remove(param);
        if (isRefObject) {
            clearAttribComposite ((RefObject) old);
        }
        //innerSet.remove(old);
        return old;
    }
    
    public void add(int param, Object obj) {        
        innerList.add(param, obj);
        if (isRefObject) {
            setAttribComposite((RefObject) obj);
        }
        //if (!innerSet.add(obj)) {
        //    throw new DuplicateException(obj, getMetaElement());
        //}
    }
    
    public boolean add(Object obj) {        
        boolean res = innerList.add(obj);
        if (isRefObject && res) {
            setAttribComposite((RefObject) obj);
        }
        //if (!innerSet.add(obj)) {
        //    throw new DuplicateException(obj, getMetaElement());
        //}
        return res;
    }
    
    public ListIterator listIterator(int param) {
        return new DeferredAttrListIterator(innerList.listIterator(param));
    }
    
    public Iterator iterator() {
        return new DeferredAttrListIterator(innerList.listIterator());
    }
    
    public ListIterator listIterator() {
        return new DeferredAttrListIterator(innerList.listIterator());
    }
    
    public List subList(int param, int param1) {
        return innerList.subList(param,  param1);
    }
    
    public boolean contains(Object obj) {
        return innerList.contains(obj);
    }
    
    public boolean containsAll(Collection collection) {
        return innerList.containsAll(collection);
    }
    
    public boolean addAll(Collection c) {
        // should not be called
        throw new DebugException();
    }
    
    public void clear() {
        // should not be called
        throw new DebugException();
    }
    
    public boolean isEmpty() {
        return innerList.isEmpty();
    }
    
    public boolean removeAll(Collection c) {
        // should not be called
        throw new DebugException();
    }
    
    public boolean retainAll(Collection c) {
        // should not be called
        throw new DebugException();
    }
    
    public int size() {
        return innerList.size();
    }
    
    public Object[] toArray() {
        return innerList.toArray();
    }
    
    public Object[] toArray(Object[] a) {
        return innerList.toArray(a);
    }
    
    public boolean addAll(int index, Collection c) {
        // should not be called
        throw new DebugException();
    }
    
    public Object get(int index) {
        return innerList.get(index);
    }
    
    public int indexOf(Object o) {
        return innerList.indexOf(o);
    }
    
    public int lastIndexOf(Object o) {
        return innerList.lastIndexOf(o);
    }

    // DeferredAttrListIterator .................................................
    class DeferredAttrListIterator implements ListIterator {
        
        private Object lastRead;
        private ListIterator innerIterator;
        
        DeferredAttrListIterator(ListIterator iterator) {
            this.innerIterator = iterator;
        }
        
        public void remove() {            
            innerIterator.remove();
            //innerSet.remove(lastRead);
            if (isRefObject) {
                clearAttribComposite((RefObject) lastRead);
            }
        }
        
        public void add(Object obj) {            
            innerIterator.add(obj);
            //if (!innerSet.add(obj)) {
            //    throw new DuplicateException(obj, getMetaElement());
            //}
            if (isRefObject) {
                setAttribComposite((RefObject) obj);
            }
        }
        
        public void set(Object obj) {
            innerIterator.set(obj);
            //innerSet.remove(lastRead);
            //if (!innerSet.add(obj)) {
            //    throw new DuplicateException(obj, getMetaElement());
            //}
            if (isRefObject) {
                if (((Element) lastRead).isValid()) {
                    clearAttribComposite((RefObject) lastRead);
                }
                setAttribComposite((RefObject) obj);
            }
        }
        
        public boolean hasNext() {
            return innerIterator.hasNext();
        }
        
        public boolean hasPrevious() {
            return innerIterator.hasPrevious();
        }
        
        public Object next() {
            return lastRead = innerIterator.next();
        }

        public int nextIndex() {
            return innerIterator.nextIndex();
        }
        
        public Object previous() {
            return lastRead = innerIterator.previous();
        }
        
        public int previousIndex() {
            return innerIterator.previousIndex();
        }
        
    } // DeferredAttrListIterator
}
