/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.javacore.jmiimpl.javamodel;

import java.util.*;
import javax.jmi.reflect.ConstraintViolationException;
import org.netbeans.jmi.javamodel.ConstructorInvocation;
import org.netbeans.jmi.javamodel.ConstructorInvocationClass;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.PrimaryExpression;
import org.netbeans.lib.java.parser.ASTree;
import org.netbeans.lib.java.parser.ASTreeTypes;
import org.netbeans.lib.java.parser.ParserTokens;
import org.netbeans.mdr.storagemodel.StorableObject;
import org.netbeans.modules.javacore.parser.ASTProvider;

/**
 *
 * @author  Martin Matula
 */
public abstract class ConstructorInvocationImpl extends InvocationImpl implements ConstructorInvocation {
    private boolean hasSuper = false;
    private PrimaryExpression parentClass;
    
    /** Creates a new instance of ConstructorInvocationImpl */
    public ConstructorInvocationImpl(StorableObject o) {
        super(o);
    }
    
    public String getName() {
        return null;
    }
    
    public void setName(String name) {
        throw new ConstraintViolationException(null, null, "Cannot change name of constructor invocation."); // NOI18N
    }
    
    public void setParentClass(PrimaryExpression expression) {
        objectChanged(CHANGED_PARENT_CLASS);
        changeChild(getParentClass(), expression);
        this.parentClass = expression;
    }
    
    public PrimaryExpression getParentClass() {
        if (!childrenInited) {
            initChildren();
        }
        return parentClass;
    }
    
    public boolean isHasSuper() {
        if (isChanged(CHANGED_HAS_SUPER)) {
            return hasSuper;
        } else {
            return getASTree().getSubTrees()[2].getType() != ParserTokens.THIS;
        }
    }
    
    public void setHasSuper(boolean hasSuper) {
        objectChanged(CHANGED_HAS_SUPER);
        this.hasSuper = hasSuper;
    }
    
    public List getChildren() {
        List list = new ArrayList(4);
        addIfNotNull(list, getParentClass()); 
        list.addAll(super.getChildren());
        return list;
    }
    
    protected void initChildren() {
        childrenInited = false;
        ASTree tree = getASTree();
        if (tree != null) {
            ASTree[] parts = tree.getSubTrees();
            parentClass = (PrimaryExpression) initOrCreate(parentClass, parts[0]);
            parameters = createChildrenList(parameters, "parameters", parts[3], ASTreeTypes.ARGUMENT_LIST, CHANGED_PARAMETERS, false); // NOI18N
        }
        childrenInited = true;
    }
    
    public String getSourceText() {
        String origElem;
        if ((origElem = checkChange()) != null)
            return origElem;
        StringBuffer buf = new StringBuffer();
        boolean hasSuper = isHasSuper();
        StatementImpl parentClass = (StatementImpl) getParentClass();
        List params = getParameters();
        buf.append('\n');
        buf.append(getIndentation());
        if (parentClass != null) {
            buf.append(parentClass.getSourceText());
            buf.append('.');
        }
        if (hasSuper) {
            buf.append("super"); // NOI18N
        } else {
            buf.append("this"); // NOI18N
        }            
        formatElementPart(PAR_OPEN_BRACKET, buf);
        Iterator iter = params.iterator();
        while (iter.hasNext()) {
            StatementImpl par = (StatementImpl) iter.next();
            buf.append(par.getSourceText());
            if (iter.hasNext()) {
                formatElementPart(MetadataElement.COMMA, buf);
            }
        }
        formatElementPart(PAR_CLOSE_BRACKET, buf);
        buf.append(';');
        return buf.toString();
    }

    public void getDiff(List diff) {
        ASTProvider parser = getParser();
        ASTree tree = getASTree();
        ASTree[] children = tree.getSubTrees();

        MetadataElement parentClass = (MetadataElement) getParentClass();
        if ((isChanged(CHANGED_PARENT_CLASS) && children[0] != null && parentClass != null) || isChanged(CHANGED_CHILDREN)) {
            getChildDiff(diff, parser, children[0], parentClass, CHANGED_PARENT_CLASS);
        } else if (isChanged(CHANGED_PARENT_CLASS)) {
            int endOffset = parser.getToken(children[2].getFirstToken()).getStartOffset();
            if (children[0] == null) {
                diff.add(new DiffElement(endOffset, endOffset, parentClass.getSourceText().concat(".")));
            } else {
                int startOffset = parser.getToken(children[0].getFirstToken()).getStartOffset();
                diff.add(new DiffElement(startOffset, endOffset, ""));
            }
        }

        if (isChanged(CHANGED_HAS_SUPER)) {
            replaceNode(diff, parser, children[2], isHasSuper() ? "super" : "this", 0, null);
        }
        
        getCollectionDiff(diff, parser, CHANGED_PARAMETERS, children[3], ASTreeTypes.ARGUMENT_LIST, getParameters(), parser.getToken(tree.getLastToken() - 1).getStartOffset(), formatElementPart(MetadataElement.COMMA));
    }
    
    void setData(boolean hasSuper, PrimaryExpression parentClass, List parameters) {
        //if (name != null) throw new ConstraintViolationException(null, null, "Cannot set name of constructor invocation to a non-null value.");
        setData(name, parameters);
        changeChild(null, parentClass);
        this.parentClass = parentClass;
        this.hasSuper = hasSuper;
    }

    protected void _delete() {
        // --- delete components -------------------------------------------
        if (childrenInited) {
            deleteChild(parentClass);
        }
        // --- delete links -----------------------------------------------
        // no links to delete
        // --- call super ---------------------------------------
        super._delete();
    }
    
    public void replaceChild(Element oldElement,Element newElement) {
        if (childrenInited) {
            if (oldElement.equals(parentClass)) {
                setParentClass((PrimaryExpression)newElement);
            }
        }
    }
    
    public Element duplicate(JavaModelPackage targetExtent) {
        return targetExtent.getConstructorInvocation().createConstructorInvocation(
                null,
                duplicateList(getParameters(), targetExtent),
                isHasSuper(), 
                (PrimaryExpression) duplicateElement(getParentClass(), targetExtent)
               );
    }
}
