/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.javacore.jmiimpl.javamodel;

import java.util.*;
import org.netbeans.jmi.javamodel.Condition;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.Expression;
import org.netbeans.mdr.storagemodel.StorableObject;

/**
 *
 * @author  mm109185
 */
public abstract class ConditionImpl extends StatementImpl implements Condition {
    protected Expression expression = null;
    
    /** Creates a new instance of ConditionImpl */
    public ConditionImpl(StorableObject o) {
        super(o);
    }
    
    public void setExpression(Expression ex) {
        objectChanged(CHANGED_EXPRESSION);
        changeChild(getExpression(), ex);
        this.expression = ex;
    }
    
    public Expression getExpression() {
        if (!childrenInited) {
            initChildren();
        }
        return expression;
    }

    protected void _delete() {
        // --- delete components -------------------------------------------
        if (childrenInited) {
            deleteChild(expression);
        }
        // --- delete links -----------------------------------------------
        // no links to delete
        // --- call super ---------------------------------------
        super._delete();
    }
    
    public void replaceChild(Element oldElement,Element newElement) {
        if (oldElement.equals(expression)) {
            setExpression((Expression)newElement);
        }
    }

    public List getChildren() {
        List list = new ArrayList(1);
        addIfNotNull(list, getExpression()); 
        return list;
    }
}
