/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.javacore.jmiimpl.javamodel;

import java.util.Collections;
import java.util.List;
import javax.jmi.reflect.InvalidObjectException;
import org.netbeans.jmi.javamodel.Codebase;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.ElementPartKind;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.mdr.handlers.InstanceHandler;
import org.netbeans.mdr.storagemodel.StorableObject;

/**
 *
 * @author Pavel Flaska
 */
public abstract class CodebaseImpl extends InstanceHandler implements Codebase {
    
    /** Creates a new instance of CodebaseImpl */
    public CodebaseImpl(StorableObject s) {
        super(s);
    }
    
    public List getChildren() {
        return Collections.EMPTY_LIST;
    }
    
    public Resource getResource() {
        return null;
    }
    
    public boolean isValid() {
        try {
            _getDelegate();
            return true;
        } catch (InvalidObjectException e) {
            return false;
        }
    }
    
    public void replaceChild(Element oldElement, Element newElement) {
    }

    public int getStartOffset() {
        throw new UnsupportedOperationException();
    }
    
    public int getEndOffset() {
        throw new UnsupportedOperationException();
    }
    
    public int getPartStartOffset(ElementPartKind part) {
        throw new UnsupportedOperationException();
    }

    public int getPartEndOffset(ElementPartKind part) {
        throw new UnsupportedOperationException();
    }
    
    public Element duplicate() {
        throw new UnsupportedOperationException("The operation is intentionally unsupported at this element."); // NOI18N 
    }
    
}
