/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.javacore.jmiimpl.javamodel;

import javax.jmi.reflect.ConstraintViolationException;
import org.netbeans.jmi.javamodel.ClassExpression;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.jmi.javamodel.TypeReference;
import org.netbeans.lib.java.parser.ASTree;
import org.netbeans.mdr.storagemodel.StorableObject;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.jmi.javamodel.JavaModelPackage;

/**
 *
 * @author Martin Matula
 */
public abstract class ClassExpressionImpl extends ExpressionImpl implements ClassExpression {
    private TypeReference className;
    private Type type;
    
    /** Creates a new instance of ClassExpressionImpl */
    public ClassExpressionImpl(StorableObject o) {
        super(o);
        type = ((JavaModelPackage) refImmediatePackage()).getType().resolve("java.lang.Class"); // NOI18N
    }
    
    void setData(TypeReference className) {
        changeChild(null, className);
        this.className = className;
    }
    
    public Type getType() {
        return type;
    }

    public void setType(Type newValue) {
        throw new ConstraintViolationException(this, null, "ClassExpression type is read-only."); // NOI18N
    }

    public TypeReference getClassName() {
        if (!childrenInited) {
            initChildren();
        }
        return className;
    }

    public void setClassName(TypeReference className) {
        objectChanged(CHANGED_CLASS_NAME);
        changeChild(getClassName(), className);
        this.className = className;
    }

    protected ASTree getNameAST() {
        return getASTree().getSubTrees()[0];
    }

    public List getChildren() {
        List result = new ArrayList(1);
        addIfNotNull(result, getClassName());
        return result;
    }

    protected void initChildren() {
        childrenInited = false;
        ASTree tree = getASTree();
        if (tree != null) {
            className = (TypeReference) initOrCreate(className, tree.getSubTrees()[0]);
        }
        childrenInited = true;
    }

    public String getSourceText() {
        String origElem;
        if ((origElem = checkChange()) != null)
            return origElem;
        return ((MetadataElement) getClassName()).getSourceText() + ".class"; // NOI18N
    }
    
    public void getDiff(List diff) {
        getChildDiff(diff, getParser(), getASTree().getSubTrees()[0], (MetadataElement) getClassName(), CHANGED_CLASS_NAME);
    }

    protected void _delete() {
        // --- delete components -------------------------------------------
        if (childrenInited) {
            deleteChild(className);
        }
        // --- delete links -----------------------------------------------
        // no links to delete
        // --- call super ---------------------------------------
        super._delete();
    }

    public void replaceChild(Element oldElement,Element newElement) {
        if (childrenInited) {
            if (oldElement.equals(className)) {
                setClassName((TypeReference)newElement);
            }
        }
    }
    
    public Element duplicate(JavaModelPackage targetExtent) {
        return targetExtent.getClassExpression().createClassExpression((TypeReference) duplicateElement(getClassName(), targetExtent));
    }
}
