/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.javacore.jmiimpl.javamodel;

import java.util.List;
import javax.jmi.reflect.ConstraintViolationException;
import org.netbeans.jmi.javamodel.CharLiteral;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.PrimitiveTypeKindEnum;
import org.netbeans.lib.java.parser.Token;
import org.netbeans.mdr.storagemodel.StorableObject;

/**
 *
 * @author  Martin Matula
 */
public abstract class CharLiteralImpl extends LiteralImpl implements CharLiteral {
    private String value;
    
    public CharLiteralImpl(StorableObject o) {
        super(o);
        type = ((JavaModelPackage) refImmediatePackage()).getType().resolve(PrimitiveTypeKindEnum.CHAR.toString());
    }

    public void setValue(String value) {
        objectChanged(CHANGED_VALUE);
        doValueChange(value);
    }
    
    public String getValue() {
        if (isChanged(CHANGED_VALUE)) {
            return value;
        } else {
            return "" + ((Token) getASTree()).getValue();
        }
    }
    
    public String getSourceText() {
        String origElem;
        if ((origElem = checkChange()) != null)
            return origElem;
        return getText();
    }
    
    public void getDiff(List diff) {
        replaceNode(diff, getParser(), getASTree(), getText(), 0, null);
    }
    
    private String getText() {
        return "'" + String.valueOf(getValue()) + '\''; // NOI18N
    }
    
    void setData(String value) {
        doValueChange(value);
    }
    
    private void doValueChange(String value) {
        if (value == null) {
            this.value = "\000"; // NOI18N
        } else {
            if (value.length() != 1) throw new ConstraintViolationException(null, null, "Must pass exactly one character."); // NOI18N
            this.value = value;
        }
    }
    
    public Element duplicate(JavaModelPackage targetExtent) {
        return targetExtent.getCharLiteral().createCharLiteral(getValue());
    }
}
