/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.javacore.jmiimpl.javamodel;

import org.netbeans.jmi.javamodel.CharLiteral;
import org.netbeans.jmi.javamodel.CharLiteralClass;
import org.netbeans.jmi.javamodel.Expression;
import org.netbeans.jmi.javamodel.MultipartId;
import org.netbeans.jmi.javamodel.PrimaryExpression;
import org.netbeans.mdr.storagemodel.StorableClass;



/**
 *
 * @author  mm109185
 */
public abstract class CharLiteralClassImpl extends MEFactory implements CharLiteralClass {
    
    /** Creates a new instance of CharLiteralClassImpl */
    public CharLiteralClassImpl(StorableClass s) {
        super(s);
    }
    
    /**
     * The default factory operation used to create an instance object.
     * @return The created instance object.
     */
    public CharLiteral createCharLiteral() {
        return createL("\000"); // NOI18N
    }
    
    private CharLiteralImpl createL(String value) {
        CharLiteralImpl result = (CharLiteralImpl) create(null);
        result.setNew();
        result.setData(value);
        return result;
    }
    
    public CharLiteral createCharLiteral(String value) {
        return createL(value);
    }
}
