/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.javacore.jmiimpl.javamodel;

import java.util.*;
import org.netbeans.jmi.javamodel.*;
import org.netbeans.lib.java.parser.ASTree;
import org.netbeans.mdr.storagemodel.StorableObject;
import org.netbeans.modules.javacore.parser.*;

/**
 *
 * @author  Martin Matula
 */
public abstract class CatchImpl extends TransientElement implements Catch {
    private Parameter parameter;
    private StatementBlock body;
    
    /** Creates a new instance of CatchImpl */
    public CatchImpl(StorableObject o) {
        super(o);
    }
    
    public Parameter getParameter() {
        if (!childrenInited) {
            initChildren();
        }
        return parameter;
    }
    
    public void setParameter(Parameter parameter) {
        objectChanged(CHANGED_PARAMETER);
        changeChild(getParameter(), parameter);
        this.parameter = parameter;
    }
    
    public StatementBlock getBody() {
        if (!childrenInited) {
            initChildren();
        }
        return body;
    }
    
    public void setBody(StatementBlock body) {
        objectChanged(CHANGED_BODY);
        changeChild(getBody(), body);
        this.body = body;
    }
    
    public List getChildren() {
        List list = new ArrayList(2);
        addIfNotNull(list, getParameter()); 
        addIfNotNull(list, getBody()); 
        return list;
    }
    
    protected void initChildren() {
        childrenInited = false;
        ASTree tree = getASTree();
        if (tree != null) {
            ASTree[] parts = tree.getSubTrees();
            
            // parameter
            ASTree parameterAST = parts[0];
            ParameterInfo paramInfo = (ParameterInfo)getParser().getSemanticInfo(parameterAST, this);
            if (parameter == null) {
                parameter = (Parameter)createElement(paramInfo);
                changeChild(null, parameter);
            } else {
                ((SemiPersistentElement)parameter).updatePersistent(paramInfo);
                ((SemiPersistentElement)parameter).setElementInfo(paramInfo);
            }
            // body
            body = (StatementBlock) initOrCreate(body, parts[1]);
        }
        childrenInited = true;
    }
    
    String getRawText() {
        StringBuffer buf = new StringBuffer();
        StatementImpl body = (StatementImpl)getBody();
        ParameterImpl param = (ParameterImpl)getParameter();
        formatElementPart(CATCH_KEYWORD, buf);
        formatElementPart(STMT_OPEN_BRACKET, buf);
        buf.append(param.getSourceText());
        formatElementPart(STMT_CLOSE_BRACKET, buf);
        buf.append(body.getSourceText());
        return buf.toString();
    }
    
    protected String getIndentation() {
        return ((MetadataElement) refImmediateComposite()).getIndentation();
    }
    
    public void getDiff(List diff) {
        ASTProvider parser = getParser();
        ASTree[] children = getASTree().getSubTrees();
        
        getChildDiff(diff, parser, children[0], (MetadataElement) getParameter(), CHANGED_PARAMETER);
        getChildDiff(diff, parser, children[1], (MetadataElement) getBody(), CHANGED_BODY);
    }
    
    void setData(Parameter parameter, StatementBlock body) {
        changeChild(null, parameter);
        this.parameter = parameter;
        changeChild(null, body);
        this.body = body;
    }
    
    protected void _delete() {
        // --- delete components -------------------------------------------
        if (childrenInited) {
            deleteChild(parameter);
            deleteChild(body);
        }
        // --- delete links -----------------------------------------------
        // no links to delete
        // --- call super ---------------------------------------
        super._delete();
    }
    
    public void replaceChild(Element oldElement,Element newElement) {
        if (childrenInited) {
            if (oldElement.equals(parameter)) {
                setParameter((Parameter)newElement);
            }
            if (oldElement.equals(body)) {
                setBody((StatementBlock)newElement);
            }
        }
    }
    
    public Element duplicate(JavaModelPackage targetExtent) {
        return targetExtent.getCatch().createCatch(
                (Parameter) duplicateElement(getParameter(), targetExtent), (StatementBlock) duplicateElement(getBody(), targetExtent));
    }
}
