/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.javacore.jmiimpl.javamodel;

import org.netbeans.jmi.javamodel.*;
import org.netbeans.mdr.storagemodel.StorableClass;

/**
 *
 * @author  Pavel Flaska
 */
public abstract class AttributeValueClassImpl extends SemiPersistentClass implements AttributeValueClass {
    
    /** Creates a new instance of AnnotationValueClassImpl */
    public AttributeValueClassImpl(StorableClass s) {
        super(s);
    }
    
    public AttributeValue createAttributeValue() {
        AttributeValueImpl result = create(null, null, null);
        return result;
    }
    
    public AttributeValue createAttributeValue(String name, InitialValue value) {
        AttributeValueImpl result = create(name, value, null);
        return result;
    }
    
     AttributeValueImpl create(String name, InitialValue value, String valueText) {
        AttributeValueImpl result = (AttributeValueImpl) create(name, false);
        result.setNew();
        result.setData(value,valueText);
        return result;
    }

     AttributeValueImpl create(String name, boolean isTransient)  {
        AttributeValueImpl result;
        if (isTransient) {
            result = (AttributeValueImpl) createTransient();
            boolean changes = result.disableChanges;
            result.disableChanges = true;
            try {
                result.setName(name);
            } finally {
                result.disableChanges = changes;
            }
        } else {
            result = (AttributeValueImpl) super_createAttributeValue(name, null);
        }
        return result;
    }

    protected abstract AttributeValue super_createAttributeValue(String name, InitialValue value);

}
