/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.javacore.jmiimpl.javamodel;

import java.util.List;
import org.netbeans.jmi.javamodel.*;
import org.netbeans.mdr.storagemodel.StorableClass;
import org.netbeans.modules.javacore.parser.TypeRef;

/**
 *
 * @author  Pavel Flaska
 */
public abstract class AttributeClassImpl extends SemiPersistentClass implements AttributeClass {
    
    /** Creates a new instance of AttributeClassImpl */
    public AttributeClassImpl(StorableClass s) {
        super(s);
    }
    
    public Attribute createAttribute() {
        return create(null, null, 0, null, null, null, null, null);
    }
    
    public Attribute createAttribute(String name, 
                                     List annotations,
                                     int modifiers,
                                     String javadocText,
                                     JavaDoc javadoc,
                                     TypeReference typeName,
                                     InitialValue defaultValue,
                                     String defaultValueText) 
    {
        return create(name, annotations, modifiers, javadocText, javadoc, typeName, defaultValue, defaultValueText);
    }
    
    ////////////////////////////////////////////////////////////////////////////
    protected AttributeImpl create(String name,
                                   List annotations,
                                   int modifiers,
                                   String javadocText,
                                   JavaDoc javadoc,
                                   TypeReference typeName,
                                   InitialValue defaultValue,
                                   String defaultValueText) 
    {
        AttributeImpl result;
        result = (AttributeImpl) create(name, modifiers, null, false);
        result.setNew();
        result.setData(annotations, javadocText, javadoc, typeName, defaultValue, defaultValueText);
        return result;
    }
    
    public AttributeImpl create(String name, int modifiers, TypeRef type, boolean isTransient) {
        AttributeImpl result;
        if (isTransient) {
            result = (AttributeImpl) createTransient();
            boolean changes = result.disableChanges;
            result.disableChanges = true;
            try {
                result.setName(name);
                result.setModifiers(modifiers);
            } finally {
                result.disableChanges = changes;
            }
        } else {
            result = (AttributeImpl) super_createAttribute(name, null, modifiers, null, null, null, null, null);
        }
        result.setTypeRef(type);
        return result;
    }
    
    protected abstract Attribute super_createAttribute();

    protected abstract Attribute super_createAttribute(String name,
                                 List annotations,
                                 int modifiers,
                                 String javadocText,
                                 JavaDoc javadoc,
                                 TypeReference typeName,
                                 InitialValue defaultValue,
                                 String defaultValueText);
}
