/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.javacore.jmiimpl.javamodel;

import javax.jmi.reflect.RefAssociationLink;
import javax.jmi.reflect.RefObject;

import org.netbeans.jmi.javamodel.Element;

/** RefAssociationLink implementation. 
 * 
 * @author Vladimir Hudec
 */
public class AssociationLinkImpl implements RefAssociationLink {
    
    private final Element end1;
    private final Element end2;
    
    AssociationLinkImpl(Element end1, Element end2) {
        if (end1 == null || end2 == null)
            throw new NullPointerException();
        this.end1 = end1;
        this.end2 = end2;
    }
    
    public RefObject refFirstEnd() {
        return end1;
    }
    
    public RefObject refSecondEnd() {
        return end2;
    }
    
    public boolean equals(Object other) {
        if (other instanceof AssociationLinkImpl) {
            return this == other;
        } else {
            return (other instanceof RefAssociationLink) && 
                ((RefAssociationLink) other).refFirstEnd().equals(refFirstEnd()) && 
                ((RefAssociationLink) other).refSecondEnd().equals(refSecondEnd());
        }
    }
    
    public int hashCode() {
        return (refFirstEnd().refMofId() + refSecondEnd().refMofId()).hashCode();
    }
}
