/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.javacore.jmiimpl.javamodel;

import java.util.List;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.Expression;
import org.netbeans.jmi.javamodel.AssertStatement;
import org.netbeans.jmi.javamodel.AssertStatementClass;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.lib.java.parser.ASTree;
import org.netbeans.mdr.storagemodel.StorableObject;
import org.netbeans.modules.javacore.parser.ASTProvider;

/**
 *
 * @author  Martin Matula
 */
public abstract class AssertStatementImpl extends ConditionImpl implements AssertStatement {
    private Expression detail = null;
    
    /** Creates a new instance of AssertStatementImpl */
    public AssertStatementImpl(StorableObject o) {
        super(o);
    }
    
    public void setDetail(Expression detail) {
        objectChanged(CHANGED_DETAIL);
        changeChild(getDetail(), detail);
        this.detail = detail;
    }

    public List getChildren() {
        List list = super.getChildren();
        addIfNotNull(list, getDetail()); 
        return list;
    }
    
    protected void initChildren() {
        childrenInited = false;
        ASTree tree = getASTree();
        if (tree != null) {
            ASTree[] parts = tree.getSubTrees();
            expression = (Expression) initOrCreate(expression, parts[0]);
            detail = (Expression) initOrCreate(detail, parts[1]);
        }
        childrenInited = true;
    }
    
    public Expression getDetail() {
        if (!childrenInited) {
            initChildren();
        }
        return detail;
    }
    
    public String getSourceText() {
        String origElem;
        if ((origElem = checkChange()) != null)
            return origElem;
        StringBuffer buf = new StringBuffer();
        TransientElement cond = (TransientElement)getExpression();
        TransientElement detail = (TransientElement)getDetail();
        buf.append('\n');
        formatElementPart(ASSERT_KEYWORD, buf);
        buf.append(cond.getSourceText());            
        if (detail != null) {
            buf.append(" : "); // NOI18N
            buf.append(detail.getSourceText());
        }
        buf.append(';');            
        return buf.toString();
    }
    
    public void getDiff(List diff) {
        ASTProvider parser = getParser();
        ASTree tree = getASTree();
        ASTree[] children = tree.getSubTrees();
        
        getChildDiff(diff, parser, children[0], (TransientElement) getExpression(), CHANGED_EXPRESSION);
        TransientElement detail = (TransientElement) getDetail();
        getChildDiff(diff, parser, children[1], detail, CHANGED_DETAIL, parser.getToken(children[0].getLastToken()).getEndOffset(), " : "); // NOI18N
    }
    
    void setData(Expression expression, Expression detail) {
        changeChild(null, expression);
        changeChild(null, detail);
        this.expression = expression;
        this.detail = detail;
    }

    protected void _delete() {
        // --- delete components -------------------------------------------
        if (childrenInited) {
            deleteChild(detail);
        }
        // --- delete links -----------------------------------------------
        // no links to delete
        // --- call super ---------------------------------------
        super._delete();
    }
    
    public void replaceChild(Element oldElement,Element newElement) {
        if (childrenInited) {
            if (oldElement.equals(detail)) {
                setDetail((Expression)newElement);
            } else
                super.replaceChild(oldElement,newElement);
        }
    }
    
    public Element duplicate(JavaModelPackage targetExtent) {
        return targetExtent.getAssertStatement().createAssertStatement(
                (Expression) duplicateElement(getExpression(), targetExtent), 
                (Expression) duplicateElement(getDetail(), targetExtent));
    }
}
