/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.javacore.jmiimpl.javamodel;

import java.util.List;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.openide.ErrorManager;
import org.netbeans.jmi.javamodel.AnnotationClass;
import org.netbeans.jmi.javamodel.Annotation;
import org.netbeans.jmi.javamodel.MultipartId;
import org.netbeans.mdr.persistence.StorageException;
import org.netbeans.mdr.storagemodel.StorableClass;

/**
 * @author  Pavel Flaska
 */
public abstract class AnnotationClassImpl extends SemiPersistentClass implements AnnotationClass {

    protected AnnotationClassImpl(StorableClass s) {
        super(s);
    }

    public Annotation createAnnotation() {
        return createAnn(null, null);
   }

    public Annotation createAnnotation(MultipartId type, List attributeValues) {
        return createAnn(type, attributeValues);
    }
    
    private AnnotationImpl createAnn(MultipartId type, List attributeValues) {
        AnnotationImpl result = create(false);
        result.setNew();
        result.setData(type, attributeValues);
        return result;
    }
        
    AnnotationImpl create(boolean isTransient) {
        AnnotationImpl result;
        if (isTransient) {
            result = (AnnotationImpl) createTransient();
        } else {
            result = (AnnotationImpl) super_createAnnotation();
        }
        return result;
    }
    
    protected abstract Annotation super_createAnnotation();
}
