/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.javacore;

import java.awt.Dialog;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import javax.swing.WindowConstants;
import org.netbeans.modules.javacore.internalapi.ProgressEvent;
import org.netbeans.modules.javacore.internalapi.ProgressListener;
import org.netbeans.modules.javacore.internalapi.UndoManager;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.NbBundle;

/**
 *
 * @author  Jan Becicka
 */
public class UndoProgressListener implements ProgressListener {
    
    UndoProgressPanel progressPanel = null;
    Dialog dialog = null;
    
    private String getString(String key) {
        return NbBundle.getMessage(UndoProgressListener.class, key);
    }
    
    private void createProgressPanel() {
        progressPanel = new UndoProgressPanel();
        DialogDescriptor desc = new DialogDescriptor(progressPanel, "", true, new Object[]{}, null, 0, null, null);

        desc.setClosingOptions(new Object[]{});

        dialog = DialogDisplayer.getDefault().createDialog(desc);
        ((JDialog) dialog).setDefaultCloseOperation(WindowConstants.DO_NOTHING_ON_CLOSE);

        dialog.validate();
    }
    
    public void start(final ProgressEvent event) {
        final boolean isUndo = event.getOperationType() == 0;
        final String description = isUndo?((UndoManager) event.getSource()).getUndoDescription(): ((UndoManager) event.getSource()).getRedoDescription();
        SwingUtilities.invokeLater(new Runnable() {
            public void run() {
                createProgressPanel();
                dialog.setTitle(getString(isUndo?"LBL_UndoOf": "LBL_RedoOf") + ' ' + description);
                progressPanel.progress.start(event.getCount());
                dialog.setVisible(true);
            }
        });
    }
    
    public void step(final ProgressEvent event) {
        SwingUtilities.invokeLater(new Runnable() {
            public void run() {
                progressPanel.progress.progress(event.getCount());
            }
        });
    }
    
    public void stop(ProgressEvent event) {
        SwingUtilities.invokeLater(new Runnable() {
            public void run() {
                progressPanel.progress.finish();
                progressPanel = null;
                dialog.dispose();
                dialog = null;
            }
        });
    }
}
