/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.javacore;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.*;
import javax.jmi.reflect.RefObject;

/**
 *
 * @author Martin Matula
 */
public class Snapshot implements InvocationHandler {
    private final HashMap results = new HashMap();
    private RefObject wrappedObject;
    private HashSet snapshots;
    
    private Snapshot(RefObject wrappedObject) {
        this.wrappedObject = wrappedObject;
    }
    
    public Object invoke(Object proxy, java.lang.reflect.Method method, Object[] args) throws Throwable {
        Object result;
        if (wrappedObject == null) {
            result = results.get(method);
            if (result == null && !results.containsKey(method)) {
                throw new IllegalStateException("Value for " + method + " not cached.");
            }
        } else {
            result = method.invoke(wrappedObject, args);
            result = wrap(result);
            results.put(method, result);
        }
        return result;
    }
    
    private void addSnapshot(Object snapshot) {
        if (snapshots == null) {
            snapshots = new HashSet();
        }
        snapshots.add(snapshot);
    }
    
    private Object wrap(Object obj) {
        if (obj instanceof Collection) {
            return wrapCollection((Collection) obj);
        } else if (obj instanceof RefObject) {
            Object result = createSnapshot((RefObject) obj);
            addSnapshot(result);
            return result;
        } else {
            return obj;
        }
    }
    
    private Object wrapCollection(Collection col) {
        Collection result = new ArrayList();
        for (Iterator it = col.iterator(); it.hasNext();) {
            result.add(wrap(it.next()));
        }
        return result;
    }
    
    private void freeze() {
        if (snapshots != null) {
            for (Iterator it = snapshots.iterator(); it.hasNext();) {
                ((Snapshot) it.next()).freeze();
            }
            snapshots = null;
        }
        wrappedObject = null;
    }
    
    public static RefObject createSnapshot(RefObject wrappedObject) {
        Snapshot ss = new Snapshot(wrappedObject);
        Class clz = wrappedObject.getClass();
        return (RefObject) Proxy.newProxyInstance(clz.getClassLoader(), clz.getInterfaces(), ss);
    }
    
    public static void freeze(RefObject snapshot) {
        ((Snapshot) Proxy.getInvocationHandler(snapshot)).freeze();
    }
}
