/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.javacore;

import javax.swing.SwingUtilities;
import org.netbeans.modules.mdr.MDRManagerImpl;

/**
 *
 * @author  Jan Becicka
 */
public class ShutDownProgressListener implements MDRManagerImpl.ProgressListener {
    
    private ShutDownProgressPanel progressPanel = null;
    
    private ShutDownProgressPanel getPanel() {
        if (progressPanel == null) {
            progressPanel = ShutDownProgressPanel.getDefault();
        }
        return progressPanel;
    }
    
    public void init() {
        ((JMManager) JMManager.getManager()).cancelScanning();
        getPanel().setVisible(true);
    }
    
    public void start(final int count) {
        SwingUtilities.invokeLater(new Runnable() {
            public void run() {
                getPanel().start(count);
            }
        });
    }
    
    public void step() {
        SwingUtilities.invokeLater(new Runnable() {
            public void run() {
                getPanel().step();
            }
        });
    }
    
    public void stop() {
        SwingUtilities.invokeLater(new Runnable() {
            public void run() {
                getPanel().stop();
                getPanel().setVisible(false);
            }
        });
    }
}
