/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.javacore;

import java.lang.ref.WeakReference;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;

/**
 *
 * @author Martin Matula
 */
public class RequestPoster {
    
    private RequestProcessor rp;
    private WeakReference/*<RequestProcessor.Task>*/ queuedTask;

    public RequestPoster() {
    }
    
    /** Creates a new instance of RequestPoster 
     * @param rp RequestProcessor used for posting requests.
     */
    public RequestPoster(RequestProcessor rp) {
        this.rp = rp;
    }
    
    public synchronized void post(Runnable runnable) {
        RequestProcessor.Task task = queuedTask == null ? null : (RequestProcessor.Task) queuedTask.get();
        if (task != null) {
            task.cancel();
        }
        if (rp == null) rp = new RequestProcessor("Implicit RequestPoster's RP-" + hashCode()); // NOI18N
        queuedTask = new WeakReference(rp.post(runnable));
    }
}
