/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.java.hints.test;

import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;

import junit.textui.TestRunner;
import org.netbeans.jmi.javamodel.*;
import org.netbeans.junit.NbTestCase;
import org.netbeans.junit.NbTestSuite;
import org.netbeans.modules.editor.hints.spi.Hint;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.openide.LifecycleManager;
import org.openide.cookies.EditorCookie;
import org.openide.loaders.DataObject;
import org.openide.text.NbDocument;
import org.netbeans.modules.java.hints.JavaHintsProvider;

/** 
 * @author Jan Lahoda
 */
public class JavaHintsTest extends NbTestCase {
   
    /** Need to be defined because of JUnit */
    public JavaHintsTest(String name) {
        super(name);
        
    } 
    
    public static NbTestSuite suite() {
        NbTestSuite suite = new NbTestSuite();
        
        suite.addTestSuite(JavaHintsTest.class);
        
        return suite;
    }
    
    /** Use for execution inside IDE */
    public static void main(java.lang.String[] args) {
        TestRunner.run(suite());
    }

    protected void setUp() throws Exception {
        //System.setProperty("org.netbeans.modules.java.hints", "0");
    }
    protected void tearDown() {
        LifecycleManager.getDefault().saveAll();
    }
    
    private int getOffset(Document doc, int linenumber, int column) {
        return NbDocument.findLineOffset((StyledDocument) doc, linenumber - 1) + column - 1;
    }
    
    private void performHintsPresentCheck(String className, int line, int column, boolean present) throws Exception {
        JavaClass clazz = Utility.findClass(className);
        Resource res = clazz.getResource();
        DataObject od = JavaMetamodel.getManager().getDataObject(res);
        EditorCookie ec = (EditorCookie) od.getCookie(EditorCookie.class);
        
        Document doc = ec.openDocument();
        
        ec.open();
        
        //TODO: wait until opened (currently hack)
        waitUntilOpened(ec);
        
        JavaHintsProvider provider = new JavaHintsProvider();
        
        List hints = provider.getHints(doc, getOffset(doc, line, column));
        if (present) {
            assertTrue(hints != null && !hints.isEmpty());
        } else {
            assertTrue(hints == null || hints.isEmpty());
        }
    }
    
    private void performTestDoNotPerform(String className, int line, int column) throws Exception {
        JavaClass clazz = Utility.findClass(className);
        Resource res = clazz.getResource();
        DataObject od = JavaMetamodel.getManager().getDataObject(res);
        EditorCookie ec = (EditorCookie) od.getCookie(EditorCookie.class);
        
        Document doc = ec.openDocument();
        
        ec.open();
        
        //TODO: wait until opened (currently hack)
        waitUntilOpened(ec);
        
        JavaHintsProvider provider = new JavaHintsProvider();
        
        List hints = provider.getHints(doc, getOffset(doc, line, column));
        
        File hintsDump = new File(getWorkDir(), getName() + "-hints.out");
        
        Writer hintsWriter = new FileWriter(hintsDump);
        
        for (Iterator i = hints.iterator(); i.hasNext(); ) {
            Hint a = (Hint) i.next();
            
            hintsWriter.write(a.getText());
            hintsWriter.write("\n");
        }
        
        hintsWriter.close();
        
        File hintsGolden = getGoldenFile(getName() + "-hints.pass");
        
        assertFile(hintsDump, hintsGolden);
    }
    
    private void performTest(String className, String performHint, int line, int column) throws Exception {
        performTest(className, className, performHint, line, column, true);
    }
    
    private void performTest(String className, String modifiedClassName, 
            String performHint, int line, int column, boolean checkHintList) throws Exception {
        JavaClass clazz = Utility.findClass(className);
        Resource res = clazz.getResource();
        DataObject od = JavaMetamodel.getManager().getDataObject(res);
        final EditorCookie ec = (EditorCookie) od.getCookie(EditorCookie.class);
        
        Document doc = ec.openDocument();
        
        ec.open();
        waitUntilOpened(ec);
        
        JavaHintsProvider provider = new JavaHintsProvider();
        
        List hints = provider.getHints(doc, getOffset(doc, line, column));
        
        Hint toPerform = null;
        
        if (checkHintList) {
            File hintsDump = new File(getWorkDir(), getName() + "-hints.out");

            Writer hintsWriter = new FileWriter(hintsDump);

            for (Iterator i = hints.iterator(); i.hasNext(); ) {
                Hint a = (Hint) i.next();

                if (a.getText().indexOf(performHint) != (-1)) {
                    toPerform = a;
                }

                hintsWriter.write(a.getText());
                hintsWriter.write("\n");
            }

            hintsWriter.close();

            File hintsGolden = getGoldenFile(getName() + "-hints.pass");

            assertFile(hintsDump, hintsGolden);
        } else {
            for (Iterator i = hints.iterator(); i.hasNext(); ) {
                Hint a = (Hint) i.next();
                
                if (a.getText().indexOf(performHint) != (-1)) {
                    toPerform = a;
                }
            }
        }
        
        assertNotNull(toPerform);
        
        toPerform.implement();
        
        File dump   = new File(getWorkDir(), getName() + ".out");
        
        Writer writer = new FileWriter(dump);

        Document modifDoc;
        if (className.equals(modifiedClassName)) {
            modifDoc = doc;
        } else {
            clazz = Utility.findClass(modifiedClassName);
            res = clazz.getResource();
            od = JavaMetamodel.getManager().getDataObject(res);
            modifDoc = ((EditorCookie) od.getCookie(EditorCookie.class)).openDocument();
        }
        
        writer.write(modifDoc.getText(0, modifDoc.getLength()));
        
        writer.close();
        
        File golden = getGoldenFile();
        
        assertNotNull(golden);
        
        File diff   = new File(getWorkDir(), getName() + ".diff");
        
        assertFile(dump, golden, diff);
    }

    private void waitUntilOpened(final EditorCookie ec) throws Exception {
        //TODO: wait until opened (currently hack)
        SwingUtilities.invokeAndWait(new Runnable() {
            public void run() {
                while (ec.getOpenedPanes() == null) {
                    try {
                        Thread.sleep(100);
                    } catch (InterruptedException ie) {
                        // ignore
                    }
                }
            }
        });
    }
    
    public void testImportHint() throws Exception {
        performTest("org.netbeans.test.java.hints.ImportTest", "java.util.List", 22, 13);
    }
    
    public void testImportHint2() throws Exception {
        performTest("org.netbeans.test.java.hints.ImportTest2", "java.util.List", 18, 13);
    }
    
    public void testImplementAbstractMethodsHint1() throws Exception {
        performTest("org.netbeans.test.java.hints.ImplementAbstractMethods1", "Implement", 16, 60);
    }
    
    public void testImplementAbstractMethodsHint2() throws Exception {
        performTest("org.netbeans.test.java.hints.ImplementAbstractMethods2", "Implement", 17, 15);
    }

    public void testImplementAbstractMethodsHint3() throws Exception {
        performTest("org.netbeans.test.java.hints.ImplementAbstractMethods3", "Implement", 17, 25);
    }
    
    public void testImplementAbstractMethodsHint4() throws Exception {
        performTest("org.netbeans.test.java.hints.ImplementAbstractMethods4", "Implement", 16, 30);
    }
    
    public void testImplementAbstractMethodsHint5() throws Exception {
        performTest("org.netbeans.test.java.hints.ImplementAbstractMethods5", "Implement", 16, 30);
    }
    
    public void testImplementAbstractMethodsHint6() throws Exception {
        performTest("org.netbeans.test.java.hints.ImplementAbstractMethods6", "Implement", 8, 5);
    }
    
    public void testImplementAbstractMethodsHint7() throws Exception {
        performTest("org.netbeans.test.java.hints.ImplementAbstractMethods7", "Implement", 9, 25);
    }
    
    public void testImplementAbstractMethodsHint8() throws Exception {
        performTest("org.netbeans.test.java.hints.ImplementAbstractMethods8", "Implement", 12, 43);
    }
    
//    public void testAddSemicolonHint() throws Exception {
//        performTest("org.netbeans.test.java.hints.AddSemicolon", "semicolon", 17, 15);
//    }
    
    public void testAddCastHint1() throws Exception {
        performTest("org.netbeans.test.java.hints.AddCast1", "Cast", 18, 15);
    }
    
    public void testAddCastHint2() throws Exception {
        performTest("org.netbeans.test.java.hints.AddCast2", "Cast", 20, 13);
    }
    
    public void testAddCastHint3() throws Exception {
        performTest("org.netbeans.test.java.hints.AddCast3", "Cast", 20, 20);
    }
    
    public void testAddCastHint4() throws Exception {
        performTest("org.netbeans.test.java.hints.AddCast4", "Cast", 22, 10);
    }
    
    public void testAddCastHint5() throws Exception {
        performTest("org.netbeans.test.java.hints.AddCast5", "Cast", 12, 1);
    }
    
    public void testAddCastHint6() throws Exception {
        performTest("org.netbeans.test.java.hints.AddCast6", "Cast", 13, 23);
    }
    
    public void testAddCastHint7() throws Exception {
        performTest("org.netbeans.test.java.hints.AddCast7", "Cast", 12, 18);
    }
    
    public void testAddThrowsClauseHint1() throws Exception {
        performTest("org.netbeans.test.java.hints.AddThrowsClause1", "throws", 19, 30);
    }
    
    public void testAddThrowsClauseHint2() throws Exception {
        performTest("org.netbeans.test.java.hints.AddThrowsClause2", "throws", 22, 30);
    }
    
    public void testCreateElement1() throws Exception {
        performTest("org.netbeans.test.java.hints.CreateElement1", "method", 23, 16);
    }
    
    public void testCreateElement2() throws Exception {
        performTest("org.netbeans.test.java.hints.CreateElement2", "method", 23, 16);
    }
    
    public void testCreateElement3() throws Exception {
        performTest("org.netbeans.test.java.hints.CreateElement3", "method", 24, 16);
    }
    
    public void testCreateElement4() throws Exception {
        performTest("org.netbeans.test.java.hints.CreateElement4", "method", 23, 16);
    }
    
    public void testCreateElement5() throws Exception {
        performTest("org.netbeans.test.java.hints.CreateElement5", "method", 23, 16);
    }

    public void testCreateElement6() throws Exception {
        performTest("org.netbeans.test.java.hints.CreateElement6", "method", 23, 16);
    }
    
    public void testCreateElement7() throws Exception {
        performTest("org.netbeans.test.java.hints.CreateElement7", "method", 23, 16);
    }
    
    public void testCreateElement8() throws Exception {
        performTest("org.netbeans.test.java.hints.CreateElement8", "method", 24, 16);
    }
    
    public void testCreateElement9() throws Exception {
        performTest("org.netbeans.test.java.hints.CreateElement9", "method", 23, 16);
    }
    
    public void testCreateElementa() throws Exception {
        performTest("org.netbeans.test.java.hints.CreateElementa", "method", 23, 16);
    }
    
    public void testCreateField1() throws Exception {
        performTest("org.netbeans.test.java.hints.CreateField1", "field", 23, 18);
    }
    
    public void testCreateField2() throws Exception {
        performTest("org.netbeans.test.java.hints.CreateField2", "field", 23, 20);
    }
    
    public void testCreateField3() throws Exception {
        performTest("org.netbeans.test.java.hints.CreateField3", "field", 23, 20);
    }
    
    public void testCreateField4() throws Exception {
        performTest("org.netbeans.test.java.hints.CreateField4", "field", 23, 20);
    }
    
    public void testTryWrapper1() throws Exception {
        performTest("org.netbeans.test.java.hints.TryWrapper1", "try-catch", 19, 30);
    }
    public void testTryWrapper2() throws Exception {
        performTest("org.netbeans.test.java.hints.TryWrapper2", "try-catch", 19, 30);
    }
    public void testTryWrapper3() throws Exception {
        performTest("org.netbeans.test.java.hints.TryWrapper3", "try-catch", 20, 30);
    }
    public void testTryWrapper4() throws Exception {
        performTest("org.netbeans.test.java.hints.TryWrapper4", "try-catch", 19, 30);
    }
    public void testTryWrapper5() throws Exception {
        performTest("org.netbeans.test.java.hints.TryWrapper5", "try-catch", 19, 30);
    }
    public void testTryWrapper6() throws Exception {
        performTest("org.netbeans.test.java.hints.TryWrapper6", "try-catch", 19, 30);
    }
    public void testTryWrapper7() throws Exception {
        performTest("org.netbeans.test.java.hints.TryWrapper7", "try-catch", 19, 30);
    }
    public void testTryWrapper8() throws Exception {
        performTest("org.netbeans.test.java.hints.TryWrapper8", "try-catch", 21, 30);
    }
    public void testTryWrapper9() throws Exception {
        performTest("org.netbeans.test.java.hints.TryWrapper9", "try-catch", 19, 30);
    }

    public void testLocalAndParamIncorrect57990a() throws Exception {
        performTestDoNotPerform("org.netbeans.test.java.hints.LocalVarParam57990a", 23, 20);
    }
    
    public void testLocalAndParamIncorrect57990b() throws Exception {
        performTestDoNotPerform("org.netbeans.test.java.hints.LocalVarParam57990b", 23, 20);
    }
    
    public void testLocalAndParamIncorrect57990c() throws Exception {
        performTestDoNotPerform("org.netbeans.test.java.hints.LocalVarParam57990c", 23, 20);
    }

    public void testCreateLocalVariable1() throws Exception {
        performTest("org.netbeans.test.java.hints.CreateLocalVariable1", "local", 23, 15);
    }
    
    public void testCreateLocalVariable2() throws Exception {
        performTest("org.netbeans.test.java.hints.CreateLocalVariable2", "local", 19, 20);
    }
    
    public void testCreateLocalVariable3() throws Exception {
        performTest("org.netbeans.test.java.hints.CreateLocalVariable3", "local", 20, 20);
    }
    
    public void testCreateParam1() throws Exception {
        performTest("org.netbeans.test.java.hints.CreateParam1", "parameter", 23, 15);
    }
    
    public void testCreateParam2() throws Exception {
        performTest("org.netbeans.test.java.hints.CreateParam2", "parameter", 20, 15);
    }
    
    public void testIncorrectType57991() throws Exception {
        performTest("org.netbeans.test.java.hints.IncorrectType57991", "field", 23, 20);
    }
    
    public void testImportBeforeCreateElement() throws Exception {
        performTestDoNotPerform("org.netbeans.test.java.hints.ImportBeforeCreateElement", 10, 21);
    }
    
    public void testIncorrectType58119a() throws Exception {
        performTest("org.netbeans.test.java.hints.IncorrectType58119a", "field", 11, 9);
    }

    public void testIncorrectType58119b() throws Exception {
        performTest("org.netbeans.test.java.hints.IncorrectType58119b", "parameter", 9, 9);
    }

    public void testIncorrectType58119c() throws Exception {
        performTest("org.netbeans.test.java.hints.IncorrectType58119c", "local", 9, 9);
    }
    
    public void testIncorrectType58119d() throws Exception {
        performTest(
                "org.netbeans.test.java.hints.IncorrectType58119d", 
                "org.netbeans.test.java.hints.IncorrectType58119d", "Create", 13, 37, false);
    }
    
    public void testIncorrectType58119e() throws Exception {
        performTest(
                "org.netbeans.test.java.hints.IncorrectType58119f", 
                "org.netbeans.test.java.hints.IncorrectType58119e", "Create", 12, 24, false);
    }
    
    public void testTypeFromParama() throws Exception {
        performTest(
                "org.netbeans.test.java.hints.TypeFromParama", 
                "org.netbeans.test.java.hints.TypeFromParama", "field", 12, 9, false);
    }
    
    public void testTypeFromParamb() throws Exception {
        performTest(
                "org.netbeans.test.java.hints.TypeFromParamb", 
                "org.netbeans.test.java.hints.TypeFromParamb", "field", 12, 9, false);
    }
        
    public void testCastOrMethodInvocation58494a() throws Exception {
        performTest("org.netbeans.test.java.hints.CastOrMethodInvocation58494a", "Cast ...", 12, 14);
    }
    
    public void testCastOrMethodInvocation58494b() throws Exception {
        performTest("org.netbeans.test.java.hints.CastOrMethodInvocation58494b", "Cast ...", 13, 18);
    }
    
    public void testCastOrMethodInvocation58494e() throws Exception {
        performTestDoNotPerform("org.netbeans.test.java.hints.CastOrMethodInvocation58494e", 11, 24);
    }

    public void testCastOrMethodInvocation58494g() throws Exception {
        performTestDoNotPerform("org.netbeans.test.java.hints.CastOrMethodInvocation58494g", 13, 9);
    }
    
    public void testCastOrMethodInvocation58494h() throws Exception {
        performTestDoNotPerform("org.netbeans.test.java.hints.CastOrMethodInvocation58494h", 11, 22);
    }
    
    public void testInitializeVariable1() throws Exception {
        performTest("org.netbeans.test.java.hints.InitializeVariable1", "Initialize", 13, 17);
    }
    
    public void testInitializeVariable2() throws Exception {
        performTest("org.netbeans.test.java.hints.InitializeVariable2", "Initialize", 12, 17);
    }
    
    public void testInitializeVariable3() throws Exception {
        performTest("org.netbeans.test.java.hints.InitializeVariable3", "Initialize", 10, 1);
    }
    
    
}
