/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.java.hints;

import java.util.Collections;
import javax.swing.text.Position;
import org.netbeans.jmi.javamodel.CallableFeature;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.Feature;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.jmi.javamodel.Statement;
import org.netbeans.modules.editor.hints.spi.ChangeInfo;
import org.netbeans.modules.editor.hints.spi.Hint;
import org.netbeans.modules.javacore.TryWrapper;
import org.netbeans.modules.javacore.api.JavaModel;
import org.openide.util.NbBundle;

/**
 *
 * @author Jan Lahoda
 */
class TryWrapperJavaHint extends Hint {
    
    private Position   position;
    private CallableFeature cFeature;
    
    TryWrapperJavaHint(Position position, CallableFeature cFeature) {
        this.position = position;
        this.cFeature = cFeature;
    }

    public int getType() {
        return ERROR;
    }

    public String getText() {
        return NbBundle.getMessage(TryWrapperJavaHint.class, "LBL_surroundTryCatch"); // NOI18N
    }

    public ChangeInfo implement() {
        boolean fail = true;
        JavaModel.getJavaRepository().beginTrans(true);
        try {
            Resource rsc=cFeature.getResource();
            JavaModel.setClassPath(rsc);
            Element el = getStatement(rsc.getElementByOffset(position.getOffset()));
            TryWrapper tw = new TryWrapper(Collections.singletonList(el));
            
            tw.wrap();
            fail = false;
        } finally {
            JavaModel.getJavaRepository().endTrans(fail);
        }   
        return null;
    }
    
    private Statement getStatement(Element e) {
        if (e instanceof Feature || e instanceof Resource)
            return null;
        while (!(e instanceof Statement) && e != null)
            e = (Element) e.refImmediateComposite();
        return (Statement) e;
    }
}
