/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Leon Chiver. All Rights Reserved.
 */

package org.netbeans.modules.java.hints;

import java.util.List;
import javax.swing.text.Position;
import org.netbeans.jmi.javamodel.Constructor;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.Statement;
import org.netbeans.jmi.javamodel.StatementBlock;
import org.netbeans.jmi.javamodel.TypeReference;
import org.netbeans.modules.editor.hints.spi.ChangeInfo;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.openide.ErrorManager;
import org.openide.text.PositionBounds;

/**
 * Helper methods.
 * 
 * @author leon chiver
 */
final class PositionUtils {

    public static int getFirstFeatureIndex(List/*<Feature>*/ features, Class featureClass, boolean forwardSearch) {
        Object[] f = features.toArray();
        for (int i = 0; i < f.length; i++) {
            int idx = forwardSearch ? i : f.length - i - 1;
            Object obj = f[idx];
            if (featureClass.isAssignableFrom(obj.getClass())) {
                return idx;
            }
        }
        return -1;
    }
        
    public static int getProposedFieldIndex(List/*<Feature>*/ features) {
        Object[] f = features.toArray();
        int idx = -1;
        for (int i = 0; i < f.length; i++) {
            if (Field.class.isAssignableFrom(f[i].getClass())) {
                idx = i + 1;
            } else if (idx != -1) {
                break;
            }
        }
        if (idx > -1) {
            while (idx < f.length && JavaMetamodel.getManager().isElementGuarded((Element) f[idx]))
                idx++;
        }
        return idx;
    }
    
    public static int getProposedMethodIndex(List/*<Feature>*/ features) {
        int index = getFirstFeatureIndex(features, Method.class, false);
        if (index == -1) {
            // After the constructor
            index = getFirstFeatureIndex(features, Constructor.class, false);
        }
        index++;
        return index;
    }
    
    /**
     * Returns a generic ChangeInfo with null for the feature (in other
     * words, assumes that the hint operated on the same file that the
     * hint was invoked in) and contains start and end coordinates for the
     * first statement in the method.
     */
    public static ChangeInfo selectFirstStatement (Method m) {
        JavaModel.getJavaRepository().beginTrans(false);
        try {
            StatementBlock body = m.getBody();
            
            if (body!=null) {
                Position begin, end;
                List/*<Statement>*/ l = body.getStatements();
                
                if (!l.isEmpty()) {
                    Statement s = (Statement)l.get(0);
                    PositionBounds bounds = JavaMetamodel.getManager().getElementPosition(s);
                    begin = bounds.getBegin().getPosition();
                    end = bounds.getEnd().getPosition();
                } else {
                    begin = JavaMetamodel.getManager().getElementPosition(body).getBegin().getPosition();
                    end = null;
                }
                return new ChangeInfo(JavaModel.getFileObject(m.getResource()), begin, end);
            }
        } catch (Exception e) {
            ErrorManager.getDefault().notify(e);
        } finally {
            JavaModel.getJavaRepository().endTrans();         
        }
        return null;
    }
    
    public static ChangeInfo selectFieldType(Field f) {
        JavaModel.getJavaRepository().beginTrans(false);
        try {
            TypeReference ref = f.getTypeName();
            PositionBounds bounds = JavaMetamodel.getManager().getElementPosition(ref);
            Position begin = bounds.getBegin().getPosition();
            Position end = bounds.getEnd().getPosition();
            return new ChangeInfo(JavaModel.getFileObject(f.getResource()), begin, end);
        } catch (Exception e) {
            ErrorManager.getDefault().notify(e);
        } finally {
            JavaModel.getJavaRepository().endTrans();         
        }
        return null;
    }
}
